/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.util.Locale;
import net.minecraft.class_1011;
import net.minecraft.class_276;

public final class SystemUtils {
    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac");
    }

    public static boolean isWayland() {
        String waylandDisplay = System.getenv("WAYLAND_DISPLAY");
        String sessionType = System.getenv("XDG_SESSION_TYPE");
        return waylandDisplay != null && !waylandDisplay.isEmpty() || "wayland".equalsIgnoreCase(sessionType);
    }

    public static void copyImageToClipboard(BufferedImage bi) {
        ClipboardImage ci = new ClipboardImage(bi);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ci, null);
    }

    public static BufferedImage createScreenshot(class_276 fb) {
        BufferedImage bufferedimage = new BufferedImage(fb.field_1482, fb.field_1481, 2);
        try (class_1011 image = new class_1011(fb.field_1482, fb.field_1481, false);){
            RenderSystem.bindTexture((int)fb.method_30277());
            image.method_4327(0, false);
            image.method_4319();
            int[] pixelValues = image.method_61942();
            bufferedimage.setRGB(0, 0, fb.field_1482, fb.field_1481, pixelValues, 0, fb.field_1482);
        }
        return bufferedimage;
    }

    public static int getMemUsed() {
        return (int)((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L);
    }

    public static int getMemMax() {
        return (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
    }

    private static final class ClipboardImage
    implements Transferable {
        private final Image image;

        private ClipboardImage(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

