/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.type;

import com.wynntils.utils.type.BoundingBox;
import com.wynntils.utils.type.BoundingCircle;

public interface BoundingShape {
    public boolean contains(float var1, float var2);

    public static boolean intersects(BoundingBox boundingBox1, BoundingBox boundingBox2) {
        boolean xIntersects = Math.max(boundingBox1.x1(), boundingBox2.x1()) < Math.min(boundingBox1.x2(), boundingBox2.x2());
        boolean zIntersects = Math.max(boundingBox1.z1(), boundingBox2.z1()) < Math.min(boundingBox1.z2(), boundingBox2.z2());
        return xIntersects && zIntersects;
    }

    public static boolean intersects(BoundingBox boundingBox, BoundingCircle boundingCircle) {
        float deltaZ;
        float nearestX = Math.max(boundingBox.x1(), Math.min(boundingBox.x2(), boundingCircle.x()));
        float nearestZ = Math.max(boundingBox.z1(), Math.min(boundingBox.z2(), boundingCircle.z()));
        float deltaX = boundingCircle.x() - nearestX;
        return deltaX * deltaX + (deltaZ = boundingCircle.z() - nearestZ) * deltaZ < boundingCircle.radius() * boundingCircle.radius();
    }

    public static boolean intersects(BoundingCircle boundingCircle1, BoundingCircle boundingCircle2) {
        float deltaZ;
        float deltaX = boundingCircle2.x() - boundingCircle1.x();
        return deltaX * deltaX + (deltaZ = boundingCircle2.z() - boundingCircle1.z()) * deltaZ < (boundingCircle1.radius() + boundingCircle2.radius()) * (boundingCircle1.radius() + boundingCircle2.radius());
    }
}

