/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.type;

import com.wynntils.utils.StringUtils;

public record Time(long timestamp) {
    public static final Time NONE = Time.of(-1L);

    public static Time of(long timestamp) {
        return new Time(timestamp);
    }

    public static Time now() {
        return Time.of(System.currentTimeMillis());
    }

    public Time offset(int seconds) {
        if (this.equals(NONE)) {
            return this;
        }
        return Time.of(this.timestamp + (long)seconds * 1000L);
    }

    public long getOffset(Time other) {
        if (this.equals(NONE)) {
            return 0L;
        }
        if (other.equals(NONE)) {
            return 0L;
        }
        return (other.timestamp - this.timestamp) / 1000L;
    }

    public String toAbsoluteString() {
        if (this.equals(NONE)) {
            return "";
        }
        return StringUtils.formatDateTime(this.timestamp);
    }

    @Override
    public String toString() {
        if (this.equals(NONE)) {
            return "";
        }
        return StringUtils.getRelativeTimeString(this.timestamp);
    }
}

