/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.services.map.type.CustomPoiProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class MapCommand
extends Command {
    private static final SuggestionProvider<CommandSourceStack> POI_PROVIDER_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest((String[])((String[])Services.Poi.getCustomPoiProviders().stream().map(CustomPoiProvider::getName).toArray(String[]::new)), (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "map";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommandBuilder(LiteralArgumentBuilder<CommandSourceStack> base, CommandBuildContext context) {
        return (LiteralArgumentBuilder)Commands.literal((String)"map").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"poiProvider").then(Commands.literal((String)"add").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"url", (ArgumentType)StringArgumentType.string()).executes(this::addPoiProvider))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(POI_PROVIDER_SUGGESTION_PROVIDER).executes(this::removePoiProvider)))).then(Commands.literal((String)"list").executes(this::listPoiProviders))).then(Commands.literal((String)"reload").executes(this::reloadPoiProviders))).then(Commands.literal((String)"toggle").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(POI_PROVIDER_SUGGESTION_PROVIDER).executes(this::togglePoiProvider))));
    }

    private int reloadPoiProviders(CommandContext<CommandSourceStack> context) {
        Services.Poi.loadCustomPoiProviders();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Successfully reloaded POI providers.").withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    private int addPoiProvider(CommandContext<CommandSourceStack> context) {
        String name = (String)context.getArgument("name", String.class);
        String url = (String)context.getArgument("url", String.class);
        try {
            Services.Poi.addCustomPoiProvider(new CustomPoiProvider(name, new URI(url)));
        }
        catch (URISyntaxException e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"The provided URL is invalid.").withStyle(ChatFormatting.RED));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Successfully added POI provider.").withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    private int removePoiProvider(CommandContext<CommandSourceStack> context) {
        String name = (String)context.getArgument("name", String.class);
        if (!Services.Poi.removeCustomPoiProvider(name)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"The provided name does not match any POI provider.").withStyle(ChatFormatting.RED));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Successfully removed POI provider.").withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    private int listPoiProviders(CommandContext<CommandSourceStack> context) {
        MutableComponent message = Component.literal((String)"POI providers: ").withStyle(ChatFormatting.YELLOW);
        for (CustomPoiProvider poiProvider : Services.Poi.getCustomPoiProviders()) {
            message.append((Component)Component.literal((String)"\n"));
            message.append((Component)Component.literal((String)poiProvider.getName()).withStyle(ChatFormatting.GOLD));
            message.append((Component)Component.literal((String)(poiProvider.isEnabled() ? " (enabled)" : " (disabled)")).withStyle(poiProvider.isEnabled() ? ChatFormatting.GREEN : ChatFormatting.RED));
            message.append((Component)Component.empty());
            message.append((Component)Component.literal((String)" (").withStyle(ChatFormatting.GRAY));
            message.append((Component)Component.literal((String)poiProvider.getUrl().toString()).withStyle(ChatFormatting.GRAY));
            message.append((Component)Component.literal((String)")").withStyle(ChatFormatting.GRAY));
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> message, false);
        return 1;
    }

    private int togglePoiProvider(CommandContext<CommandSourceStack> context) {
        String name = (String)context.getArgument("name", String.class);
        Optional<CustomPoiProvider> poiProvider = Services.Poi.getCustomPoiProviders().stream().filter(p -> p.getName().equals(name)).findFirst();
        if (poiProvider.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"The provided name does not match any POI provider.").withStyle(ChatFormatting.RED));
            return 0;
        }
        poiProvider.get().setEnabled(!poiProvider.get().isEnabled());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Successfully toggled POI provider ").append((Component)Component.literal((String)name).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" to ")).append((Component)Component.literal((String)(((CustomPoiProvider)poiProvider.get()).isEnabled() ? "enabled" : "disabled")).withStyle(ChatFormatting.UNDERLINE)), false);
        return 1;
    }
}

