/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.wynntils.commands.BombBellCommand;
import com.wynntils.commands.CompassCommand;
import com.wynntils.commands.ConfigCommand;
import com.wynntils.commands.FeatureCommand;
import com.wynntils.commands.FunctionCommand;
import com.wynntils.commands.LocateCommand;
import com.wynntils.commands.LootrunCommand;
import com.wynntils.commands.MapCommand;
import com.wynntils.commands.OnlineMembersCommand;
import com.wynntils.commands.PlayerCommand;
import com.wynntils.commands.ServersCommand;
import com.wynntils.commands.StatisticsCommand;
import com.wynntils.commands.TerritoryCommand;
import com.wynntils.commands.WynntilsCommand;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Manager;
import com.wynntils.core.consumers.commands.ClientCommandSourceStack;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.mc.event.CommandsAddedEvent;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.neoforged.bus.api.SubscribeEvent;

public final class ClientCommandManager
extends Manager {
    private final CommandDispatcher<CommandSourceStack> clientDispatcher = new CommandDispatcher();
    private final List<Command> commandInstanceSet = new ArrayList<Command>();
    private WynntilsCommand wynntilsCommand;

    public ClientCommandManager() {
        super(List.of());
        this.registerAllCommands();
    }

    @SubscribeEvent
    public void onCommandsAdded(CommandsAddedEvent event) {
        CommandBuildContext context = event.getContext();
        for (Command command : this.commandInstanceSet) {
            command.getCommandBuilders(context).forEach(arg_0 -> this.clientDispatcher.register(arg_0));
            command.getCommandBuilders(context).stream().map(LiteralArgumentBuilder::build).forEach(node -> this.addNode(event.getRoot(), (CommandNode<? extends SharedSuggestionProvider>)node));
        }
        this.wynntilsCommand.registerWithCommands(arg_0 -> this.clientDispatcher.register(arg_0), context, this.commandInstanceSet);
        this.wynntilsCommand.registerWithCommands(builder -> this.addNode(event.getRoot(), (CommandNode<? extends SharedSuggestionProvider>)builder.build()), context, this.commandInstanceSet);
    }

    public void addNode(RootCommandNode<SharedSuggestionProvider> root, CommandNode<? extends SharedSuggestionProvider> node) {
        root.addChild(node);
    }

    public void addNodeToClientDispatcher(LiteralArgumentBuilder<CommandSourceStack> nodeBuilder) {
        this.clientDispatcher.register(nodeBuilder);
    }

    public boolean handleCommand(String message) {
        StringReader reader = new StringReader(message);
        return this.executeCommand(reader, message);
    }

    private boolean executeCommand(StringReader reader, String command) {
        ClientCommandSourceStack source = this.getSource();
        if (source == null) {
            return false;
        }
        ParseResults parse = this.clientDispatcher.parse(reader, (Object)source);
        if (!parse.getExceptions().isEmpty() || parse.getContext().getCommand() == null && parse.getContext().getChild() == null) {
            return false;
        }
        try {
            this.clientDispatcher.execute(parse);
        }
        catch (CommandSyntaxException e) {
            McUtils.sendErrorToClient(e.getRawMessage().getString());
            if (e.getInput() != null && e.getCursor() >= 0) {
                int cursor = Math.min(e.getCursor(), e.getInput().length());
                MutableComponent text = Component.literal((String)"").withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command)));
                if (cursor > 10) {
                    text.append("...");
                }
                text.append(e.getInput().substring(Math.max(0, cursor - 10), cursor));
                if (cursor < e.getInput().length()) {
                    text.append((Component)Component.literal((String)e.getInput().substring(cursor)).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.UNDERLINE}));
                }
                text.append((Component)Component.translatable((String)"command.context.here").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
                this.sendError(text);
            }
        }
        catch (RuntimeException e) {
            MutableComponent error = Component.literal((String)(e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
            this.sendError(Component.translatable((String)"command.failed").withStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)error))));
            WynntilsMod.error("Failed to execute command.", e);
        }
        return true;
    }

    private ClientCommandSourceStack getSource() {
        LocalPlayer player = McUtils.player();
        if (player == null) {
            return null;
        }
        return new ClientCommandSourceStack(player);
    }

    private void sendError(MutableComponent error) {
        McUtils.sendMessageToClient((Component)error.withStyle(ChatFormatting.RED));
    }

    public List<Command> getCommandInstanceSet() {
        return this.commandInstanceSet;
    }

    private void registerCommand(Command command) {
        this.commandInstanceSet.add(command);
    }

    private void registerCommandWithCommandSet(WynntilsCommand command) {
        this.wynntilsCommand = command;
    }

    private void registerAllCommands() {
        this.registerCommand(new BombBellCommand());
        this.registerCommand(new CompassCommand());
        this.registerCommand(new ConfigCommand());
        this.registerCommand(new FeatureCommand());
        this.registerCommand(new FunctionCommand());
        this.registerCommand(new LocateCommand());
        this.registerCommand(new LootrunCommand());
        this.registerCommand(new MapCommand());
        this.registerCommand(new OnlineMembersCommand());
        this.registerCommand(new PlayerCommand());
        this.registerCommand(new ServersCommand());
        this.registerCommand(new StatisticsCommand());
        this.registerCommand(new TerritoryCommand());
        this.registerCommandWithCommandSet(new WynntilsCommand());
    }
}

