/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.overlays;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ComparisonChain;
import com.mojang.blaze3d.platform.Window;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.AbstractConfigurable;
import com.wynntils.core.consumers.overlays.Corner;
import com.wynntils.core.consumers.overlays.DynamicOverlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.consumers.overlays.SectionCoordinates;
import com.wynntils.core.mod.type.CrashType;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.character.type.VehicleType;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.ErrorOr;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.phys.Vec2;

public abstract class Overlay
extends AbstractConfigurable
implements Comparable<Overlay> {
    @Persisted(i18nKey="overlay.wynntils.overlay.enabledTemplate")
    protected final Config<String> enabledTemplate = new Config<String>("");
    @Persisted(i18nKey="overlay.wynntils.overlay.position")
    private final Config<OverlayPosition> position = new Config<Object>(null);
    @Persisted(i18nKey="overlay.wynntils.overlay.size")
    protected final Config<OverlaySize> size = new Config<Object>(null);
    @Persisted(i18nKey="overlay.wynntils.overlay.userEnabled")
    protected final Config<Boolean> userEnabled = new Config<Boolean>(true);
    @Persisted(i18nKey="overlay.wynntils.overlay.horizontalAlignmentOverride")
    protected final Config<HorizontalAlignment> horizontalAlignmentOverride = new Config<Object>(null);
    @Persisted(i18nKey="overlay.wynntils.overlay.verticalAlignmentOverride")
    protected final Config<VerticalAlignment> verticalAlignmentOverride = new Config<Object>(null);
    private ErrorOr<Boolean> enabledTemplateCache = null;

    protected Overlay(OverlayPosition position, float width, float height) {
        this.position.store(position);
        this.size.store(new OverlaySize(width, height));
    }

    protected Overlay(OverlayPosition position, OverlaySize size) {
        this.position.store(position);
        this.size.store(size);
    }

    protected Overlay(OverlayPosition position, OverlaySize size, HorizontalAlignment horizontalAlignmentOverride, VerticalAlignment verticalAlignmentOverride) {
        this.position.store(position);
        this.size.store(size);
        this.horizontalAlignmentOverride.store(horizontalAlignmentOverride);
        this.verticalAlignmentOverride.store(verticalAlignmentOverride);
    }

    protected boolean hideWhenNoGui() {
        return true;
    }

    protected boolean isVisible() {
        return true;
    }

    protected final boolean isRendered() {
        if (this.enabledTemplateCache != null && this.enabledTemplateCache.hasError()) {
            return true;
        }
        if (this.enabledTemplateCache != null && !this.enabledTemplateCache.hasError()) {
            return this.enabledTemplateCache.getValue();
        }
        if (!this.isVisible()) {
            return false;
        }
        boolean hasGui = Models.WorldState.onWorld() && Models.Character.getVehicle() != VehicleType.DISPLAY;
        return hasGui || !this.hideWhenNoGui();
    }

    @Override
    public String getTypeName() {
        return "Overlay";
    }

    public abstract void render(GuiGraphics var1, MultiBufferSource var2, DeltaTracker var3, Window var4);

    public void renderPreview(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        this.render(guiGraphics, bufferSource, deltaTracker, window);
    }

    protected void renderOrErrorMessage(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        if (this.enabledTemplateCache != null && this.enabledTemplateCache.hasError()) {
            this.renderEnabledTemplateErrorMessage(guiGraphics, bufferSource);
        } else {
            this.render(guiGraphics, bufferSource, deltaTracker, window);
        }
    }

    private void renderEnabledTemplateErrorMessage(GuiGraphics guiGraphics, MultiBufferSource bufferSource) {
        StyledText[] errorMessage = new StyledText[]{StyledText.fromString("\u00a7c\u00a7l" + I18n.get((String)"overlay.wynntils.overlay.enabledTemplate.error", (Object[])new Object[0]) + " " + this.getTranslatedName()), StyledText.fromUnformattedString(this.enabledTemplateCache.getError())};
        BufferedFontRenderer.getInstance().renderAlignedTextInBox(guiGraphics.pose(), bufferSource, errorMessage, this.getRenderX(), this.getRenderX() + this.getWidth(), this.getRenderY(), this.getRenderY() + this.getHeight(), 0.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.0f);
    }

    protected void tick() {
    }

    protected void updateEnabledCache() {
        String template = (String)this.enabledTemplate.get();
        if (template.isBlank()) {
            this.enabledTemplateCache = null;
            return;
        }
        String formattedTemplate = StyledText.join("", Managers.Function.doFormatLines(template)).getString();
        this.enabledTemplateCache = Managers.Function.tryGetRawValueOfType(formattedTemplate, Boolean.class);
    }

    @Override
    public final void updateConfigOption(Config<?> config) {
        if (config.getFieldName().equals("userEnabled")) {
            if (config.get() == Boolean.FALSE) {
                Managers.Overlay.disableOverlay(this);
            } else {
                Managers.Overlay.enableOverlay(this);
            }
        }
        this.callOnConfigUpdate(config);
    }

    protected void onConfigUpdate(Config<?> config) {
    }

    protected void callOnConfigUpdate(Config<?> config) {
        try {
            this.onConfigUpdate(config);
        }
        catch (Throwable t) {
            if (!Managers.Overlay.isEnabled(this)) {
                return;
            }
            Managers.Overlay.disableOverlay(this);
            WynntilsMod.reportCrash(CrashType.OVERLAY, this.getTranslatedName(), this.getClass().getName(), "config update", t);
        }
    }

    @Override
    public String getTranslation(String keySuffix, Object ... parameters) {
        return I18n.get((String)("feature.wynntils." + this.getTranslationFeatureKeyName() + ".overlay." + this.getTranslationKeyName() + "." + keySuffix), (Object[])parameters);
    }

    public String getShortName() {
        return this.getClass().getSimpleName().replace("Overlay", "");
    }

    public String getDeclaringFeatureClassName() {
        return Managers.Overlay.getOverlayParent(this).getClass().getSimpleName();
    }

    private String getTranslationFeatureKeyName() {
        String name = this.getDeclaringFeatureClassName().replace("Feature", "");
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, name);
    }

    protected Boolean isUserEnabled() {
        return (Boolean)this.userEnabled.get();
    }

    public boolean shouldBeEnabled() {
        if (!this.isParentEnabled()) {
            return false;
        }
        if (this.isUserEnabled() != null) {
            return this.isUserEnabled();
        }
        return Managers.Overlay.isEnabledByDefault(this);
    }

    public final boolean isParentEnabled() {
        return Managers.Overlay.getOverlayParent(this).isEnabled();
    }

    public final String getParentTranslatedName() {
        return Managers.Overlay.getOverlayParent(this).getTranslatedName();
    }

    public float getWidth() {
        return ((OverlaySize)this.size.get()).getWidth();
    }

    public float getHeight() {
        return ((OverlaySize)this.size.get()).getHeight();
    }

    public OverlaySize getSize() {
        return (OverlaySize)this.size.get();
    }

    public OverlayPosition getPosition() {
        return (OverlayPosition)this.position.get();
    }

    public void setPosition(OverlayPosition position) {
        this.position.store(position);
    }

    public float getRenderX() {
        return this.getRenderX((OverlayPosition)this.position.get());
    }

    public float getRenderY() {
        return this.getRenderY((OverlayPosition)this.position.get());
    }

    public float getRenderX(OverlayPosition position) {
        SectionCoordinates section = Managers.Overlay.getSection(position.getAnchorSection());
        return switch (position.getHorizontalAlignment()) {
            default -> throw new MatchException(null, null);
            case HorizontalAlignment.LEFT -> (float)section.x1() + position.getHorizontalOffset();
            case HorizontalAlignment.CENTER -> ((float)(section.x1() + section.x2()) - this.getWidth()) / 2.0f + position.getHorizontalOffset();
            case HorizontalAlignment.RIGHT -> (float)section.x2() + position.getHorizontalOffset() - this.getWidth();
        };
    }

    public float getRenderY(OverlayPosition position) {
        SectionCoordinates section = Managers.Overlay.getSection(position.getAnchorSection());
        return switch (position.getVerticalAlignment()) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> (float)section.y1() + position.getVerticalOffset();
            case VerticalAlignment.MIDDLE -> ((float)(section.y1() + section.y2()) - this.getHeight()) / 2.0f + position.getVerticalOffset();
            case VerticalAlignment.BOTTOM -> (float)section.y2() + position.getVerticalOffset() - this.getHeight();
        };
    }

    public HorizontalAlignment getRenderHorizontalAlignment() {
        return this.horizontalAlignmentOverride.get() == null ? ((OverlayPosition)this.position.get()).getHorizontalAlignment() : (HorizontalAlignment)this.horizontalAlignmentOverride.get();
    }

    public VerticalAlignment getRenderVerticalAlignment() {
        return this.verticalAlignmentOverride.get() == null ? ((OverlayPosition)this.position.get()).getVerticalAlignment() : (VerticalAlignment)this.verticalAlignmentOverride.get();
    }

    public Vec2 getCornerPoints(Corner corner) {
        return switch (corner) {
            default -> throw new MatchException(null, null);
            case Corner.TOP_LEFT -> new Vec2(this.getRenderX(), this.getRenderY());
            case Corner.TOP_RIGHT -> new Vec2(this.getRenderX() + this.getWidth(), this.getRenderY());
            case Corner.BOTTOM_LEFT -> new Vec2(this.getRenderX(), this.getRenderY() + this.getHeight());
            case Corner.BOTTOM_RIGHT -> new Vec2(this.getRenderX() + this.getWidth(), this.getRenderY() + this.getHeight());
        };
    }

    @Override
    public int compareTo(Overlay other) {
        int n;
        int n2;
        ComparisonChain comparisonChain = ComparisonChain.start().compareTrueFirst(this.isParentEnabled(), other.isParentEnabled()).compare((Comparable)((Object)this.getDeclaringFeatureClassName()), (Comparable)((Object)other.getDeclaringFeatureClassName()));
        Overlay overlay = this;
        if (overlay instanceof DynamicOverlay) {
            DynamicOverlay dynamicThis = (DynamicOverlay)overlay;
            n2 = dynamicThis.getId();
        } else {
            n2 = 0;
        }
        if (other instanceof DynamicOverlay) {
            DynamicOverlay dynamicOther = (DynamicOverlay)other;
            n = dynamicOther.getId();
        } else {
            n = 0;
        }
        return comparisonChain.compare(n2, n).compare((Comparable)((Object)this.getTranslatedName()), (Comparable)((Object)other.getTranslatedName())).result();
    }

    public void setHeight(float height) {
        this.getSize().setHeight(height);
    }

    public void setWidth(float width) {
        this.getSize().setWidth(width);
    }
}

