/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.net;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.CoreComponent;
import com.wynntils.core.components.Manager;
import com.wynntils.core.components.Managers;
import com.wynntils.core.net.Dependency;
import com.wynntils.core.net.Download;
import com.wynntils.core.net.DownloadDependencyGraph;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.core.net.QueuedDownload;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.net.event.DownloadEvent;
import com.wynntils.core.net.event.UrlProcessingFinishedEvent;
import com.wynntils.core.properties.Property;
import com.wynntils.utils.StringUtils;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.neoforged.bus.api.SubscribeEvent;

public class DownloadManager
extends Manager {
    private final Property<Boolean> dumpGraph = this.createProperty(Boolean.class, "dump.graph", false);
    private final Property<Boolean> debugLogs = this.createProperty(Boolean.class, "log.debug", false);
    private final Property<Integer> maxParallelDownloads = this.createProperty(Integer.class, "max.parallel", 4);
    private final List<QueuedDownload> registeredDownloads = new ArrayList<QueuedDownload>();
    private boolean registrationLock = false;
    private DownloadDependencyGraph graph = null;
    private Set<QueuedDownload> currentDownloads;

    public DownloadManager() {
        super(List.of());
    }

    @SubscribeEvent
    public void onUrlProcessingFinished(UrlProcessingFinishedEvent event) {
        this.download(false);
    }

    public void initComponents(Map<Class<? extends CoreComponent>, List<CoreComponent>> componentMap) {
        componentMap.forEach((componentClass, coreComponents) -> coreComponents.forEach(coreComponent -> coreComponent.registerDownloads(new DownloadRegistry(this, (CoreComponent)coreComponent))));
        this.registrationLock = true;
        this.graph = DownloadDependencyGraph.build(this.registeredDownloads);
        if (this.dumpGraph.get().booleanValue()) {
            this.graph.logGraph();
        }
    }

    public void retryDownload(QueuedDownload download) {
        if (!this.registrationLock) {
            throw new IllegalStateException("Cannot retry downloads while the download graph is still being built.");
        }
        if (!this.graph.state().finished()) {
            throw new IllegalStateException("Cannot retry downloads while a download is already happening.");
        }
        this.graph.markDownloadRetry(download);
        this.download(true);
    }

    public List<QueuedDownload> registeredDownloads() {
        return Collections.unmodifiableList(this.registeredDownloads);
    }

    public DownloadDependencyGraph.DownloadDependencyGraphState graphState() {
        return this.graph.state();
    }

    public DownloadDependencyGraph.NodeState getDownloadState(QueuedDownload download) {
        return this.graph.getDownloadState(download);
    }

    QueuedDownload queueDownload(UrlId urlId, CoreComponent callerComponent, Dependency dependency) {
        if (this.registrationLock) {
            throw new IllegalStateException("Cannot queue downloads after the download graph is already built.");
        }
        QueuedDownload queuedDownload = new QueuedDownload(callerComponent, urlId, dependency);
        this.registeredDownloads.add(queuedDownload);
        return queuedDownload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(boolean partialRedownload) {
        if (!partialRedownload) {
            this.graph.resetState();
            this.currentDownloads = new LinkedHashSet<QueuedDownload>();
        }
        WynntilsMod.postEventOnMainThread(new DownloadEvent.Started(partialRedownload));
        Set<QueuedDownload> set = this.currentDownloads;
        synchronized (set) {
            for (int i = 0; i < this.maxParallelDownloads.get(); ++i) {
                QueuedDownload queuedDownload2 = this.graph.nextDownload();
                if (queuedDownload2 == null) {
                    if (!partialRedownload) {
                        WynntilsMod.warn("Max parallel downloads was not reached, but there are no more downloads to start.");
                    }
                    return;
                }
                this.currentDownloads.add(queuedDownload2);
                this.getDownload(queuedDownload2);
            }
            if (this.debugLogs.get().booleanValue()) {
                WynntilsMod.info("[DownloadManager] Started downloads:");
                this.currentDownloads.forEach(queuedDownload -> WynntilsMod.info("  - %s -> %s".formatted(new Object[]{StringUtils.capitalizeFirst(queuedDownload.callerComponent().getJsonName()), queuedDownload.urlId()})));
            }
        }
    }

    private Download getDownload(QueuedDownload queuedDownload) {
        Download download = Managers.Net.download(queuedDownload.urlId());
        Consumer<Reader> readerHandler = queuedDownload.onCompletionReader();
        if (readerHandler != null) {
            download.handleReader(this.wrapDownloadHandler(readerHandler, queuedDownload), this.wrapDownloadFailure(queuedDownload));
            return download;
        }
        Consumer<JsonObject> jsonObjectHandler = queuedDownload.onCompletionJsonObject();
        if (jsonObjectHandler != null) {
            download.handleJsonObject(this.wrapDownloadHandler(jsonObjectHandler, queuedDownload), this.wrapDownloadFailure(queuedDownload));
            return download;
        }
        Consumer<JsonArray> jsonArrayHandler = queuedDownload.onCompletionJsonArray();
        if (jsonArrayHandler != null) {
            download.handleJsonArray(this.wrapDownloadHandler(jsonArrayHandler, queuedDownload), this.wrapDownloadFailure(queuedDownload));
            return download;
        }
        throw new IllegalStateException("Queued download has no handler set: " + String.valueOf(queuedDownload));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueNextDownload(QueuedDownload finishedDownload) {
        Set<QueuedDownload> set = this.currentDownloads;
        synchronized (set) {
            QueuedDownload nextDownload = this.graph.nextDownload();
            for (QueuedDownload queuedDownload : this.currentDownloads) {
                if (!queuedDownload.equals(finishedDownload)) continue;
                if (this.debugLogs.get().booleanValue()) {
                    WynntilsMod.info(String.valueOf(queuedDownload) + " -> " + String.valueOf(nextDownload));
                }
                this.currentDownloads.remove(queuedDownload);
                if (nextDownload != null) {
                    this.currentDownloads.add(nextDownload);
                    this.getDownload(nextDownload);
                }
                return;
            }
            WynntilsMod.error("Finished, but not yet replaced download not found in the current downloads: " + String.valueOf(finishedDownload));
        }
    }

    private <T> Consumer<T> wrapDownloadHandler(Consumer<T> handler, QueuedDownload download) {
        return result -> {
            handler.accept(result);
            if (this.debugLogs.get().booleanValue()) {
                WynntilsMod.info("Download finished: " + StringUtils.capitalizeFirst(download.callerComponent().getJsonName()) + " -> " + String.valueOf((Object)download.urlId()));
            }
            this.graph.markDownloadCompleted(download);
            this.queueNextDownload(download);
            this.checkDownloadsFinished();
        };
    }

    private Consumer<Throwable> wrapDownloadFailure(QueuedDownload download) {
        return throwable -> {
            if (this.debugLogs.get().booleanValue()) {
                WynntilsMod.warn("Download failed: " + StringUtils.capitalizeFirst(download.callerComponent().getJsonName()) + " -> " + String.valueOf((Object)download.urlId()));
            }
            this.graph.markDownloadError(download);
            this.queueNextDownload(download);
            this.checkDownloadsFinished();
        };
    }

    private void checkDownloadsFinished() {
        if (!this.graph.isFinished()) {
            return;
        }
        if (!this.currentDownloads.isEmpty()) {
            return;
        }
        WynntilsMod.info("[DownloadManager] Downloads finished.");
        if (this.graph.hasError()) {
            WynntilsMod.postEventOnMainThread(new DownloadEvent.Failed());
            WynntilsMod.warn("[DownloadManager] Some downloads failed. See the statistics for more information.");
        } else {
            WynntilsMod.postEventOnMainThread(new DownloadEvent.Completed());
            WynntilsMod.info("[DownloadManager] Downloads succeeded.");
        }
        if (this.graph.hasError() || this.debugLogs.get().booleanValue()) {
            WynntilsMod.info("[DownloadManager] Download statistics:");
            WynntilsMod.info("  - Total downloads: %d".formatted(this.graph.totalDownloads()));
            WynntilsMod.info("  - Successful downloads: %d".formatted(this.graph.successfulDownloads()));
            WynntilsMod.info("  - Failed downloads: %d".formatted(this.graph.failedDownloads()));
            WynntilsMod.info("  - Error Rate: %.0f%%".formatted(Float.valueOf(this.graph.errorRate() * 100.0f)));
        }
    }
}

