/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.net;

import com.google.gson.JsonObject;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Manager;
import com.wynntils.core.components.Managers;
import com.wynntils.core.net.ApiResponse;
import com.wynntils.core.net.Download;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.net.UrlManager;
import com.wynntils.core.net.event.NetResultProcessedEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import org.apache.commons.codec.digest.DigestUtils;

public final class NetManager
extends Manager {
    static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();
    private static final int REQUEST_TIMEOUT_MILLIS = 10000;
    private static final File CACHE_DIR = WynntilsMod.getModStorageDir("cache");
    private static final String USER_AGENT = String.format("Wynntils Artemis\\%s+MC-%s (%s) %s", new Object[]{WynntilsMod.getVersion(), SharedConstants.getCurrentVersion().getName(), WynntilsMod.isDevelopmentEnvironment() ? "dev" : "client", WynntilsMod.getModLoader()});

    public NetManager() {
        super(List.of());
    }

    public ApiResponse callApi(UrlId urlId, Map<String, String> arguments, Map<String, String> headers) {
        UrlManager.UrlInfo urlInfo = Managers.Url.getUrlInfo(urlId);
        return this.createApiResponse(urlId, urlInfo, arguments, headers);
    }

    public ApiResponse callApi(UrlId urlId, Map<String, String> arguments) {
        return this.callApi(urlId, arguments, Map.of());
    }

    public ApiResponse callApi(UrlId urlId) {
        return this.callApi(urlId, Map.of());
    }

    public Download download(URI uri, String localFileName) {
        File localFile = new File(CACHE_DIR, localFileName);
        return this.download(uri, localFile, new NetResultProcessedEvent.ForLocalFile(localFileName));
    }

    public Download download(URI uri, String localFileName, String expectedHash) {
        File localFile = new File(CACHE_DIR, localFileName);
        return this.download(uri, localFile, expectedHash, new NetResultProcessedEvent.ForLocalFile(localFileName));
    }

    public Download download(UrlId urlId) {
        UrlManager.UrlInfo urlInfo = Managers.Url.getUrlInfo(urlId);
        URI uri = URI.create(urlInfo.url());
        String localFileName = urlId.getId();
        File localFile = new File(CACHE_DIR, localFileName);
        if (urlInfo.md5().isPresent()) {
            return this.download(uri, localFile, urlInfo.md5().get(), new NetResultProcessedEvent.ForUrlId(urlId));
        }
        return this.download(uri, localFile, new NetResultProcessedEvent.ForUrlId(urlId));
    }

    private Download download(URI uri, File localFile, NetResultProcessedEvent processedEvent) {
        return new Download(localFile.getName(), localFile, this.createGetRequest(uri, Map.of()), processedEvent);
    }

    private Download download(URI uri, File localFile, String expectedHash, NetResultProcessedEvent processedEvent) {
        if (WynntilsMod.isDevelopmentEnvironment() && new File(CACHE_DIR, "keep").exists()) {
            return new Download(localFile.getName(), localFile, processedEvent);
        }
        if (this.checkLocalHash(localFile, expectedHash)) {
            return new Download(localFile.getName(), localFile, processedEvent);
        }
        return this.download(uri, localFile, processedEvent);
    }

    public File getCacheDir() {
        return CACHE_DIR;
    }

    public File getCacheFile(String localFileName) {
        return new File(CACHE_DIR, localFileName);
    }

    public void openLink(URI url) {
        Util.getPlatform().openUri(url);
    }

    public void openLink(UrlId urlId, Map<String, String> arguments) {
        URI uri = URI.create(Managers.Url.buildUrl(urlId, arguments));
        this.openLink(uri);
    }

    private HttpRequest createGetRequest(URI uri, Map<String, String> headers) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(uri).timeout(Duration.ofMillis(10000L)).header("User-Agent", USER_AGENT);
        headers.forEach(builder::header);
        return builder.build();
    }

    private HttpRequest createPostRequest(URI uri, Map<String, String> headers, JsonObject jsonArgs) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(uri).timeout(Duration.ofMillis(10000L)).header("User-Agent", USER_AGENT).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonArgs.toString()));
        headers.forEach(builder::header);
        return builder.build();
    }

    private ApiResponse createApiResponse(UrlId urlId, UrlManager.UrlInfo urlInfo, Map<String, String> arguments, Map<String, String> headers) {
        if (urlInfo.method() == UrlManager.Method.GET) {
            URI uri = URI.create(Managers.Url.buildUrl(urlInfo, arguments));
            HttpRequest request = this.createGetRequest(uri, headers);
            return new ApiResponse(urlId.toString(), request, new NetResultProcessedEvent.ForUrlId(urlId));
        }
        assert (urlInfo.method() == UrlManager.Method.POST);
        assert (arguments.keySet().equals(new HashSet<String>(urlInfo.arguments()))) : "Arguments mismatch for " + String.valueOf((Object)urlId) + ", expected: " + String.valueOf(urlInfo.arguments()) + " got: " + String.valueOf(arguments.keySet());
        JsonObject jsonArgs = new JsonObject();
        arguments.forEach((arg_0, arg_1) -> ((JsonObject)jsonArgs).addProperty(arg_0, arg_1));
        URI uri = URI.create(urlInfo.url());
        HttpRequest request = this.createPostRequest(uri, headers, jsonArgs);
        return new ApiResponse(urlId.toString(), request, new NetResultProcessedEvent.ForUrlId(urlId));
    }

    private boolean checkLocalHash(File localFile, String expectedHash) {
        boolean bl;
        block10: {
            if (!localFile.exists()) {
                return false;
            }
            InputStream is = Files.newInputStream(localFile.toPath(), new OpenOption[0]);
            try {
                String fileHash = DigestUtils.md5Hex((InputStream)is);
                boolean hashMatches = fileHash.equalsIgnoreCase(expectedHash);
                if (WynntilsMod.isDevelopmentEnvironment() && !hashMatches) {
                    WynntilsMod.warn("Hash mismatch for " + localFile.getPath() + ": " + fileHash + " != " + expectedHash + ". If you see this often, check urls.json, there might be an outdated hash.");
                }
                bl = hashMatches;
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    WynntilsMod.warn("Error when calculating md5 for " + localFile.getPath(), e);
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }
}

