/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.combat;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.mc.event.UseItemEvent;
import com.wynntils.models.items.items.game.HorseItem;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.MouseUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.COMBAT)
public class HorseMountFeature
extends Feature {
    private static final ResourceLocation HORSE_WHISTLE_ID = ResourceLocation.fromNamespaceAndPath((String)"wynntils", (String)"horse.whistle");
    private static final SoundEvent HORSE_WHISTLE_SOUND = SoundEvent.createVariableRangeEvent((ResourceLocation)HORSE_WHISTLE_ID);
    private static final int SEARCH_RADIUS = 6;
    private static final int SUMMON_DELAY_TICKS = 6;
    private static final List<String> HORSE_ERROR_MESSAGES = List.of("There is no room for a horse.", "Your horse is scared to come out right now, too many mobs are nearby.", "You cannot interact with your horse at the moment.", "You cannot use your horse here!", "Your horse spawn was disabled (in vanish)!", "You can not use a horse while in war.", "You cannot use your vehicle here!");
    private int prevItem = -1;
    private boolean alreadySetPrevItem = false;
    private boolean cancelMountingHorse = false;
    @RegisterKeyBind
    private final KeyBind mountHorseKeyBind = new KeyBind("Mount Horse", 82, true, this::mountHorse);
    @Persisted
    private final Config<Boolean> guaranteedMount = new Config<Boolean>(true);
    @Persisted
    private final Config<Integer> summonAttempts = new Config<Integer>(8);
    @Persisted
    private final Config<Boolean> playWhistle = new Config<Boolean>(true);

    @SubscribeEvent
    public void onUseItem(UseItemEvent event) {
        if (!((Boolean)this.guaranteedMount.get()).booleanValue()) {
            return;
        }
        ItemStack itemStack = McUtils.player().getMainHandItem();
        Optional<HorseItem> horseItemOpt = Models.Item.asWynnItem(itemStack, HorseItem.class);
        if (horseItemOpt.isEmpty()) {
            return;
        }
        this.mountHorse();
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onChatReceived(ChatMessageEvent.Match e) {
        this.cancelMountingHorse = HORSE_ERROR_MESSAGES.stream().anyMatch(msg -> e.getMessage().getString().contains((CharSequence)msg));
    }

    private void mountHorse() {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        LocalPlayer player = McUtils.player();
        if (player.getVehicle() != null) {
            this.postHorseErrorMessage(MountHorseStatus.ALREADY_RIDING);
            return;
        }
        AbstractHorse horse = Models.Horse.searchForHorseNearby((Player)player, 6);
        if (horse == null) {
            int horseInventorySlot = Models.Horse.findHorseSlotNum();
            if (horseInventorySlot > 8 || horseInventorySlot == -1) {
                this.postHorseErrorMessage(MountHorseStatus.NO_HORSE);
                return;
            }
            this.trySummonAndMountHorse(horseInventorySlot, (Integer)this.summonAttempts.get());
        } else {
            this.mountHorse((Entity)horse);
        }
    }

    private void mountHorse(Entity horse) {
        int nonConflictingSlot;
        if (((Boolean)this.playWhistle.get()).booleanValue()) {
            McUtils.playSoundAmbient(HORSE_WHISTLE_SOUND);
        }
        if ((nonConflictingSlot = this.findNonConflictingSlot()) == -1) {
            this.postHorseErrorMessage(MountHorseStatus.CONFLICTING_SLOTS);
            return;
        }
        McUtils.sendPacket(new ServerboundSetCarriedItemPacket(nonConflictingSlot));
        McUtils.sendPacket(ServerboundInteractPacket.createInteractionPacket((Entity)horse, (boolean)false, (InteractionHand)InteractionHand.MAIN_HAND));
        McUtils.sendPacket(new ServerboundSetCarriedItemPacket(this.prevItem));
    }

    private int findNonConflictingSlot() {
        for (int i = 0; i < 9; ++i) {
            ItemStack itemStack = McUtils.inventory().getItem(i);
            if (itemStack.isEmpty()) {
                return i;
            }
            Optional<HorseItem> horseItemOpt = Models.Item.asWynnItem(itemStack, HorseItem.class);
            if (!horseItemOpt.isPresent()) continue;
            return i;
        }
        return -1;
    }

    private void trySummonAndMountHorse(int horseInventorySlot, int attempts) {
        if (attempts <= 0) {
            this.postHorseErrorMessage(MountHorseStatus.NO_HORSE);
            McUtils.sendPacket(new ServerboundSetCarriedItemPacket(this.prevItem));
            return;
        }
        if (this.cancelMountingHorse) {
            McUtils.sendPacket(new ServerboundSetCarriedItemPacket(this.prevItem));
            this.cancelMountingHorse = false;
            return;
        }
        if (!this.alreadySetPrevItem) {
            this.prevItem = McUtils.inventory().selected;
            this.alreadySetPrevItem = true;
        }
        Managers.TickScheduler.scheduleLater(() -> {
            LocalPlayer player = McUtils.player();
            if (player == null) {
                return;
            }
            AbstractHorse horse = Models.Horse.searchForHorseNearby((Player)player, 6);
            if (horse != null) {
                McUtils.sendPacket(new ServerboundSetCarriedItemPacket(this.prevItem));
                this.alreadySetPrevItem = false;
                this.mountHorse((Entity)horse);
                return;
            }
            McUtils.sendPacket(new ServerboundSetCarriedItemPacket(horseInventorySlot));
            MouseUtils.sendRightClickInput();
            this.trySummonAndMountHorse(horseInventorySlot, attempts - 1);
        }, 6);
    }

    private void postHorseErrorMessage(MountHorseStatus status) {
        Managers.Notification.queueMessage((Component)Component.translatable((String)status.getTcString()).withStyle(ChatFormatting.DARK_RED));
    }

    private static enum MountHorseStatus {
        NO_HORSE("feature.wynntils.horseMount.noHorse"),
        ALREADY_RIDING("feature.wynntils.horseMount.alreadyRiding"),
        CONFLICTING_SLOTS("feature.wynntils.horseMount.conflictingSlots");

        private final String tcString;

        private MountHorseStatus(String tcString) {
            this.tcString = tcString;
        }

        private String getTcString() {
            return this.tcString;
        }
    }
}

