/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.combat;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.RenderEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.spells.event.SpellEvent;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.type.CappedValue;
import java.util.Optional;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.COMBAT)
public class SpellCastVignetteFeature
extends Feature {
    private static final int SHOW_VIGNETTE_TICKS = 40;
    @Persisted
    private final Config<Boolean> renderVignette = new Config<Boolean>(true);
    @Persisted
    private final Config<Integer> vignetteFadeTime = new Config<Integer>(12);
    @Persisted
    private final Config<Float> vignetteIntensity = new Config<Float>(Float.valueOf(0.75f));
    @Persisted
    private final Config<Float> maxItensityPercent = new Config<Float>(Float.valueOf(100.0f));
    @Persisted
    private final Config<CustomColor> vignetteColor = new Config<CustomColor>(new CustomColor(0, 71, 201));
    private int vignetteTimer;
    private float intensity;

    @SubscribeEvent
    public void onSpellCast(SpellEvent.Cast event) {
        Optional<CappedValue> manaOpt = Models.CharacterStats.getMana();
        if (manaOpt.isEmpty()) {
            WynntilsMod.warn("Mana is empty, cannot calculate relative cost of spell cast");
            return;
        }
        if (event.getManaCost() == 0) {
            return;
        }
        int currentMana = Math.max(1, manaOpt.get().current());
        float relativeCost = Math.min((float)event.getManaCost() / (float)currentMana, ((Float)this.maxItensityPercent.get()).floatValue() / 100.0f);
        this.intensity = ((Float)this.vignetteIntensity.get()).floatValue() * relativeCost;
        this.vignetteTimer = 40;
    }

    @SubscribeEvent
    public void onSpellFailed(SpellEvent.Failed event) {
        this.intensity = 0.0f;
        this.vignetteTimer = 0;
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (this.vignetteTimer <= 0) {
            return;
        }
        --this.vignetteTimer;
    }

    @SubscribeEvent
    public void onRender(RenderEvent.Post event) {
        if (!((Boolean)this.renderVignette.get()).booleanValue() || this.intensity <= 0.0f) {
            return;
        }
        int shownTicks = 40 - this.vignetteTimer;
        int fade = (Integer)this.vignetteFadeTime.get() - shownTicks;
        if (fade > 0) {
            float alpha = this.intensity * ((float)fade / (float)((Integer)this.vignetteFadeTime.get()).intValue());
            RenderUtils.renderVignetteOverlay(event.getPoseStack(), (CustomColor)this.vignetteColor.get(), alpha);
        }
    }
}

