/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.combat;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.models.token.event.TokenGatekeeperEvent;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.CappedValue;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.COMBAT)
public class TokenTrackerBellFeature
extends Feature {
    @Persisted
    private final Config<Boolean> playSound = new Config<Boolean>(true);

    @SubscribeEvent
    public void onInventoryUpdated(TokenGatekeeperEvent.InventoryUpdated event) {
        if (!((Boolean)this.playSound.get()).booleanValue()) {
            return;
        }
        if (event.getCount() < event.getOldCount()) {
            return;
        }
        CappedValue deposited = event.getGatekeeper().getDeposited();
        int collected = Models.Token.inInventory(event.getGatekeeper()) + deposited.current();
        if (collected < deposited.max()) {
            return;
        }
        if (collected > deposited.max() + 5) {
            return;
        }
        McUtils.mc().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BELL_BLOCK, (float)0.7f, (float)0.75f));
    }
}

