/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.debug;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.PacketEvent;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundEntityPositionSyncPacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.protocol.game.ServerboundClientTickEndPacket;
import net.minecraft.network.protocol.game.ServerboundContainerButtonClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.neoforged.bus.api.SubscribeEvent;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@StartDisabled
@ConfigCategory(value=Category.DEBUG)
public class PacketDebuggerFeature
extends Feature {
    private static final List<Class<? extends Packet<?>>> IGNORE_LIST = List.of(ServerboundKeepAlivePacket.class, ServerboundClientTickEndPacket.class, ClientboundKeepAlivePacket.class, ClientboundSetTimePacket.class, ClientboundUpdateAdvancementsPacket.class, ClientboundUpdateAttributesPacket.class, ClientboundLevelParticlesPacket.class, ClientboundPlayerInfoUpdatePacket.class, ClientboundSetEquipmentPacket.class, ClientboundForgetLevelChunkPacket.class, ClientboundLightUpdatePacket.class, ClientboundSetChunkCacheCenterPacket.class, ClientboundLevelChunkWithLightPacket.class, ClientboundSectionBlocksUpdatePacket.class, ClientboundBlockUpdatePacket.class, ClientboundAddEntityPacket.class, ClientboundMoveEntityPacket.Pos.class, ClientboundMoveEntityPacket.PosRot.class, ClientboundMoveEntityPacket.Rot.class, ClientboundRotateHeadPacket.class, ClientboundSetEntityDataPacket.class, ClientboundSetEntityMotionPacket.class, ClientboundTeleportEntityPacket.class, ClientboundEntityPositionSyncPacket.class, ClientboundSetPassengersPacket.class, ServerboundMovePlayerPacket.Pos.class, ServerboundMovePlayerPacket.PosRot.class, ServerboundMovePlayerPacket.Rot.class);
    private static final List<Class<? extends Packet<?>>> EXTENDED_IGNORE_LIST = List.of(ClientboundSoundPacket.class, ClientboundSystemChatPacket.class);
    private static final List<Class<? extends Packet<?>>> CONTAINER_PACKETS = List.of(ClientboundContainerSetContentPacket.class, ClientboundContainerSetSlotPacket.class, ClientboundContainerSetDataPacket.class, ClientboundContainerSetSlotPacket.class, ServerboundContainerClickPacket.class, ServerboundContainerClickPacket.class, ServerboundContainerButtonClickPacket.class, ServerboundContainerClosePacket.class);
    private static final Class<? extends Packet<?>> PARTICLE_PACKET_CLASS = ClientboundLevelParticlesPacket.class;
    private static final List<Class<? extends Packet<?>>> ENTITY_PACKETS = List.of(ClientboundAddEntityPacket.class, ClientboundRemoveEntitiesPacket.class, ClientboundMoveEntityPacket.Pos.class, ClientboundMoveEntityPacket.PosRot.class, ClientboundMoveEntityPacket.Rot.class, ClientboundRotateHeadPacket.class, ClientboundSetEntityDataPacket.class, ClientboundSetEntityMotionPacket.class, ClientboundTeleportEntityPacket.class);
    @Persisted
    private final Config<PacketFilterType> packetFilterType = new Config<PacketFilterType>(PacketFilterType.FILTERED);

    private String describePacket(Packet<?> packet) {
        return ReflectionToStringBuilder.toString(packet, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE).replaceFirst("net\\.minecraft\\.network\\.protocol\\..*\\.", "");
    }

    @SubscribeEvent
    public void onPacketSent(PacketEvent.PacketSentEvent<?> e) {
        Object packet = e.getPacket();
        if (((PacketFilterType)((Object)this.packetFilterType.get())).isPacketExcluded(packet.getClass())) {
            return;
        }
        WynntilsMod.info("SENT packet: " + this.describePacket((Packet<?>)packet));
    }

    @SubscribeEvent
    public void onPacketReceived(PacketEvent.PacketReceivedEvent<?> e) {
        Object packet = e.getPacket();
        if (((PacketFilterType)((Object)this.packetFilterType.get())).isPacketExcluded(packet.getClass())) {
            return;
        }
        WynntilsMod.info("RECV packet: " + this.describePacket((Packet<?>)packet));
    }

    private static enum PacketFilterType {
        ALL(packetClass -> false),
        FILTERED(IGNORE_LIST::contains),
        EXTENDED_FILTERED(packetClass -> IGNORE_LIST.contains(packetClass) || EXTENDED_IGNORE_LIST.contains(packetClass)),
        CONTAINER_ONLY(packetClass -> !CONTAINER_PACKETS.contains(packetClass)),
        PARTICLE_ONLY(packetClass -> !PARTICLE_PACKET_CLASS.equals(packetClass)),
        ENTITY_ONLY(packetClass -> !ENTITY_PACKETS.contains(packetClass));

        private final Predicate<Class<? extends Packet>> filterPredicate;

        private PacketFilterType(Predicate<Class<? extends Packet>> filterPredicate) {
            this.filterPredicate = filterPredicate;
        }

        public boolean isPacketExcluded(Class<? extends Packet> packetClass) {
            return this.filterPredicate.test(packetClass);
        }
    }
}

