/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.overlays;

import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.annotations.OverlayInfo;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.RenderEvent;
import com.wynntils.models.war.event.GuildWarEvent;
import com.wynntils.models.war.type.WarBattleInfo;
import com.wynntils.models.war.type.WarTowerState;
import com.wynntils.overlays.TowerStatsOverlay;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.McUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.OVERLAYS)
public class TowerStatsFeature
extends Feature {
    private static final int SEPARATOR_LENGTH = 40;
    @OverlayInfo(renderType=RenderEvent.ElementType.GUI)
    public final Overlay towerStatsOverlay = new TowerStatsOverlay();
    @Persisted
    private final Config<Boolean> printTowerStatsOnEnd = new Config<Boolean>(true);

    @SubscribeEvent
    public void onWarEnd(GuildWarEvent.Ended event) {
        if (!((Boolean)this.printTowerStatsOnEnd.get()).booleanValue()) {
            return;
        }
        WarBattleInfo warBattleInfo = event.getWarBattleInfo();
        WarTowerState initialTowerState = warBattleInfo.getInitialState();
        WarTowerState endTowerState = warBattleInfo.getCurrentState();
        MutableComponent message = Component.empty().append((Component)TowerStatsFeature.getSeparatorComponent("Tower Stats - Initial", 40));
        message = message.append((Component)TowerStatsFeature.getTowerStatsComponent(warBattleInfo.getTerritory(), warBattleInfo.getOwnerGuild(), initialTowerState));
        if (!endTowerState.equals(initialTowerState)) {
            message = message.append((Component)TowerStatsFeature.getSeparatorComponent("Tower Stats - End", 40)).append((Component)TowerStatsFeature.getTowerStatsComponent(warBattleInfo.getTerritory(), warBattleInfo.getOwnerGuild(), endTowerState));
        }
        message = message.append((Component)Component.literal((String)"\ud83d\udd51 Time in War: ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"%s".formatted(StringUtils.formatDuration(warBattleInfo.getTotalLengthSeconds()))).withStyle(ChatFormatting.WHITE))).append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)"\u2694 DPS: ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"%s".formatted(StringUtils.integerToShortString(warBattleInfo.getDps(Long.MAX_VALUE)))).withStyle(ChatFormatting.WHITE))).append((Component)Component.literal((String)"\n"));
        message = message.append((Component)Component.literal((String)"%s".formatted("=".repeat(40))).withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.STRIKETHROUGH));
        String messageString = StyledText.fromComponent((Component)message).getStringWithoutFormatting();
        message = message.withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to copy to clipboard."))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, messageString)));
        McUtils.sendMessageToClient((Component)message);
    }

    private static MutableComponent getSeparatorComponent(String text, int separatorLength) {
        String separator = "=".repeat(separatorLength);
        int textLength = text.length();
        int totalPadding = separatorLength - textLength;
        int paddingSide = totalPadding / 2;
        String padding = " ".repeat(paddingSide);
        return Component.empty().append((Component)Component.literal((String)(separator + "\n")).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.STRIKETHROUGH})).append((Component)Component.literal((String)(padding + text + padding + "\n")).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.BOLD})).append((Component)Component.literal((String)(separator + "\n")).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.STRIKETHROUGH}));
    }

    private static MutableComponent getTowerStatsComponent(String territory, String ownerGuild, WarTowerState initialTowerState) {
        return Component.empty().append((Component)Component.literal((String)territory).withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.BOLD).append((Component)Component.literal((String)" [").withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.literal((String)"%s".formatted(ownerGuild)).withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)"]").withStyle(ChatFormatting.DARK_AQUA))))).append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)"\u2723 Damage: ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"%s".formatted(initialTowerState.damage().low())).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)" - ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"%s".formatted(initialTowerState.damage().high())).withStyle(ChatFormatting.WHITE)))).append((Component)Component.literal((String)"\n"))).append((Component)Component.literal((String)"\u27a1 Attack Speed: ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)"%.2fx".formatted(initialTowerState.attackSpeed())).withStyle(ChatFormatting.WHITE))).append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)"\u2764 Health: ").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)"%d".formatted(initialTowerState.health())).withStyle(ChatFormatting.WHITE))).append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)"\u26e8 Defense: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)("%.2f".formatted(initialTowerState.defense()) + "%")).withStyle(ChatFormatting.WHITE))).append((Component)Component.literal((String)"\n"));
    }
}

