/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.players;

import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.PlayerRenderLayerEvent;
import com.wynntils.mc.extension.EntityRenderStateExtension;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;

@StartDisabled
@ConfigCategory(value=Category.PLAYERS)
public class PlayerArmorHidingFeature
extends Feature {
    @Persisted
    private final Config<Boolean> hideHelmets = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> hideChestplates = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> hideLeggings = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> hideBoots = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showCosmetics = new Config<Boolean>(true);

    @SubscribeEvent
    public void onPlayerArmorRender(PlayerRenderLayerEvent.Armor event) {
        switch (event.getSlot()) {
            case HEAD: {
                if (!((Boolean)this.hideHelmets.get()).booleanValue()) {
                    return;
                }
                if (!((Boolean)this.showCosmetics.get()).booleanValue()) {
                    event.setCanceled(true);
                    return;
                }
                Entity entity = ((EntityRenderStateExtension)event.getPlayerRenderState()).getEntity();
                if (!(entity instanceof AbstractClientPlayer)) {
                    return;
                }
                AbstractClientPlayer player = (AbstractClientPlayer)entity;
                ItemStack headItem = player.getItemBySlot(event.getSlot());
                if (headItem.getItem() == Items.POTION) break;
                event.setCanceled(true);
                break;
            }
            case CHEST: {
                if (!((Boolean)this.hideChestplates.get()).booleanValue()) break;
                event.setCanceled(true);
                break;
            }
            case LEGS: {
                if (!((Boolean)this.hideLeggings.get()).booleanValue()) break;
                event.setCanceled(true);
                break;
            }
            case FEET: {
                if (!((Boolean)this.hideBoots.get()).booleanValue()) break;
                event.setCanceled(true);
            }
        }
    }
}

