/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.redirects;

import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.mc.event.SubtitleSetTextEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.bus.api.SubscribeEvent;
import org.apache.commons.lang3.StringUtils;

@ConfigCategory(value=Category.REDIRECTS)
public class TerritoryMessageRedirectFeature
extends Feature {
    private static final Pattern TERRITORY_MESSAGE_PATTERN = Pattern.compile("\u00a77\\[You are now (\\S+) (.+)\\]");

    @SubscribeEvent
    public void onSubtitleSetText(SubtitleSetTextEvent event) {
        String directionalArrow;
        StyledText styledText = StyledText.fromComponent(event.getComponent());
        Matcher matcher = styledText.getMatcher(TERRITORY_MESSAGE_PATTERN);
        if (!matcher.matches()) {
            return;
        }
        event.setCanceled(true);
        String rawDirection = matcher.group(1);
        String rawTerritoryName = matcher.group(2);
        switch (rawDirection) {
            case "entering": {
                directionalArrow = "\u2192";
                break;
            }
            case "leaving": {
                directionalArrow = "\u2190";
                break;
            }
            default: {
                return;
            }
        }
        String territoryName = StringUtils.capitalize((String)rawTerritoryName);
        StyledText enteringMessage = StyledText.fromString(String.format("\u00a77%s %s", directionalArrow, territoryName));
        Managers.Notification.queueMessage(enteringMessage);
    }

    @SubscribeEvent
    public void onChat(ChatMessageEvent.Match event) {
        if (event.getMessage().getMatcher(TERRITORY_MESSAGE_PATTERN).matches()) {
            event.cancelChat();
        }
    }
}

