/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.ui;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.wrappedscreen.event.WrappedScreenOpenEvent;
import com.wynntils.mc.event.ContainerClickEvent;
import com.wynntils.mc.event.MenuEvent;
import com.wynntils.mc.event.ScreenClosedEvent;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.models.containers.containers.GuildTerritoriesContainer;
import com.wynntils.screens.territorymanagement.TerritoryManagementScreen;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.ShiftBehavior;
import com.wynntils.utils.wynn.ContainerUtils;
import com.wynntils.utils.wynn.InventoryUtils;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UI)
public class CustomTerritoryManagementScreenFeature
extends Feature {
    private static final Pattern TERRITORY_MANAGE_ITEM_PATTERN = Pattern.compile("\u00a7e\u00a7lTerritories \\[.+\\]");
    private static final Pattern MANAGE_TITLE_PATTERN = Pattern.compile(".+: Manage");
    private static final Pattern BACK_BUTTON_PATTERN = Pattern.compile("\u00a77\u00a7lBack");
    private static final int COMPASS_INVENTORY_SLOT = 42;
    private static final int GUILD_MANAGEMENT_SLOT = 26;
    private static final int TERRITORY_MANAGEMENT_SLOT = 14;
    @RegisterKeyBind
    private final KeyBind openTerritoryMenu = new KeyBind("Open Territory Menu", 85, true, this::updateTerritoryMenu);
    @Persisted
    private final Config<ShiftBehavior> shiftBehaviorConfig = new Config<ShiftBehavior>(ShiftBehavior.DISABLED_IF_SHIFT_HELD);
    @Persisted
    public final Storage<Boolean> screenHighlightLegend = new Storage<Boolean>(true);
    @Persisted
    public final Storage<Boolean> screenTerritoryProductionTooltip = new Storage<Boolean>(true);
    private boolean shiftClickedTerritoryItem = false;
    private boolean customScreenOpened = false;
    private boolean openTerritoryManagement = false;

    @SubscribeEvent
    public void onWrappedScreenOpen(WrappedScreenOpenEvent event) {
        if (event.getWrappedScreenClass() != TerritoryManagementScreen.class) {
            return;
        }
        boolean shouldOpen = false;
        switch ((ShiftBehavior)((Object)this.shiftBehaviorConfig.get())) {
            case NONE: {
                shouldOpen = true;
                break;
            }
            case ENABLED_IF_SHIFT_HELD: {
                if (!this.shiftClickedTerritoryItem) break;
                shouldOpen = true;
                break;
            }
            case DISABLED_IF_SHIFT_HELD: {
                if (this.shiftClickedTerritoryItem) break;
                shouldOpen = true;
            }
        }
        if (shouldOpen) {
            event.setOpenScreen(true);
            this.customScreenOpened = true;
        }
    }

    @SubscribeEvent
    public void onScreenClosed(ScreenClosedEvent.Post event) {
        this.customScreenOpened = false;
        this.openTerritoryManagement = false;
    }

    @SubscribeEvent
    public void onScreenInit(ScreenInitEvent.Pre event) {
        if (StyledText.fromComponent(event.getScreen().getTitle()).matches(MANAGE_TITLE_PATTERN)) {
            this.customScreenOpened = false;
        }
    }

    @SubscribeEvent
    public void onContainerClick(ContainerClickEvent event) {
        if (StyledText.fromComponent(event.getItemStack().getHoverName()).matches(TERRITORY_MANAGE_ITEM_PATTERN)) {
            this.shiftClickedTerritoryItem = KeyboardUtils.isShiftDown();
            return;
        }
        if (!this.customScreenOpened) {
            return;
        }
        if (Models.Container.getCurrentContainer() instanceof GuildTerritoriesContainer) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        StyledText itemName = StyledText.fromComponent(itemStack.getHoverName());
        if (itemName.matches(BACK_BUTTON_PATTERN)) {
            this.openTerritoryManagement = true;
        }
    }

    @SubscribeEvent
    public void onMenuOpenPre(MenuEvent.MenuOpenedEvent.Pre event) {
        if (!this.openTerritoryManagement) {
            return;
        }
        this.openTerritoryManagement = false;
        StyledText title = StyledText.fromComponent(event.getTitle());
        if (title.matches(MANAGE_TITLE_PATTERN)) {
            event.setCanceled(true);
            AbstractContainerMenu container = event.getMenuType().create(event.getContainerId(), McUtils.inventory());
            ContainerUtils.clickOnSlot(14, event.getContainerId(), 0, (List<ItemStack>)container.getItems());
        } else if (title.equalsString("\udaff\udfdc\ue003")) {
            event.setCanceled(true);
            this.openTerritoryManagement = true;
            AbstractContainerMenu container = event.getMenuType().create(event.getContainerId(), McUtils.inventory());
            ContainerUtils.clickOnSlot(26, event.getContainerId(), 0, (List<ItemStack>)container.getItems());
        }
    }

    private void updateTerritoryMenu() {
        this.openTerritoryManagement = true;
        if (Models.War.isWarActive()) {
            InventoryUtils.sendInventorySlotMouseClick(42, InventoryUtils.MouseClickType.LEFT_CLICK);
        } else {
            Handlers.Command.sendCommandImmediately("guild manage");
        }
    }
}

