/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.functions.generic;

import com.wynntils.core.consumers.functions.GenericFunction;
import com.wynntils.core.consumers.functions.arguments.Argument;
import com.wynntils.core.consumers.functions.arguments.FunctionArguments;
import com.wynntils.core.consumers.functions.arguments.ListArgument;
import java.util.List;

public final class MathFunctions {

    public static class RandomFunction
    extends GenericFunction<Double> {
        @Override
        public Double getValue(FunctionArguments arguments) {
            double min = arguments.getArgument("min").getIntegerValue().intValue();
            double max = arguments.getArgument("max").getIntegerValue().intValue();
            return Math.random() * (max - min) + min;
        }

        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("min", Number.class, null), new Argument<Object>("max", Number.class, null)));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("rand");
        }
    }

    public static class LongFunction
    extends GenericFunction<Long> {
        @Override
        public Long getValue(FunctionArguments arguments) {
            return arguments.getArgument("value").getLongValue();
        }

        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("value", Number.class, null)));
        }
    }

    public static class IntegerFunction
    extends GenericFunction<Integer> {
        @Override
        public Integer getValue(FunctionArguments arguments) {
            return arguments.getArgument("value").getIntegerValue();
        }

        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("value", Number.class, null)));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("int");
        }
    }

    public static class RoundFunction
    extends GenericFunction<Double> {
        @Override
        public Double getValue(FunctionArguments arguments) {
            double roundingValue = Math.pow(10.0, arguments.getArgument("decimals").getIntegerValue().intValue());
            return (double)Math.round(arguments.getArgument("value").getDoubleValue() * roundingValue) / roundingValue;
        }

        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("value", Number.class, null), new Argument<Object>("decimals", Integer.class, null)));
        }
    }

    public static class MinFunction
    extends GenericFunction<Double> {
        @Override
        public Double getValue(FunctionArguments arguments) {
            List<Number> values = arguments.getArgument("values").getNumberList();
            return values.stream().mapToDouble(Number::doubleValue).min().orElse(0.0);
        }

        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new ListArgument<Number>("values", Number.class)));
        }
    }

    public static class MaxFunction
    extends GenericFunction<Double> {
        @Override
        public Double getValue(FunctionArguments arguments) {
            List<Number> values = arguments.getArgument("values").getNumberList();
            return values.stream().mapToDouble(Number::doubleValue).max().orElse(0.0);
        }

        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new ListArgument<Number>("values", Number.class)));
        }
    }

    public static class SquareRootFunction
    extends GenericFunction<Double> {
        @Override
        public Double getValue(FunctionArguments arguments) {
            return Math.sqrt(arguments.getArgument("value").getDoubleValue());
        }

        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("value", Number.class, null)));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("sqrt");
        }
    }

    public static class PowerFunction
    extends GenericFunction<Double> {
        @Override
        public Double getValue(FunctionArguments arguments) {
            return Math.pow(arguments.getArgument("base").getDoubleValue(), arguments.getArgument("exponent").getDoubleValue());
        }

        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("base", Number.class, null), new Argument<Object>("exponent", Number.class, null)));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("pow");
        }
    }

    public static class ModuloFunction
    extends GenericFunction<Double> {
        @Override
        public Double getValue(FunctionArguments arguments) {
            return arguments.getArgument("dividend").getDoubleValue() % arguments.getArgument("divisor").getDoubleValue();
        }

        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("dividend", Number.class, null), new Argument<Object>("divisor", Number.class, null)));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("mod");
        }
    }

    public static class DivideFunction
    extends GenericFunction<Double> {
        @Override
        public Double getValue(FunctionArguments arguments) {
            return arguments.getArgument("dividend").getDoubleValue() / arguments.getArgument("divisor").getDoubleValue();
        }

        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("dividend", Number.class, null), new Argument<Object>("divisor", Number.class, null)));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("div");
        }
    }

    public static class MultiplyFunction
    extends GenericFunction<Double> {
        @Override
        public Double getValue(FunctionArguments arguments) {
            List<Number> values = arguments.getArgument("values").getNumberList();
            return values.stream().mapToDouble(Number::doubleValue).reduce(1.0, (a, b) -> a * b);
        }

        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new ListArgument<Number>("values", Number.class)));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("mul");
        }
    }

    public static class SubtractFunction
    extends GenericFunction<Double> {
        @Override
        public Double getValue(FunctionArguments arguments) {
            return arguments.getArgument("first").getDoubleValue() - arguments.getArgument("second").getDoubleValue();
        }

        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("first", Number.class, null), new Argument<Object>("second", Number.class, null)));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("sub");
        }
    }

    public static class AddFunction
    extends GenericFunction<Double> {
        @Override
        public Double getValue(FunctionArguments arguments) {
            List<Number> values = arguments.getArgument("values").getNumberList();
            return values.stream().mapToDouble(Number::doubleValue).sum();
        }

        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new ListArgument<Number>("values", Number.class)));
        }
    }
}

