/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.functions.generic;

import com.wynntils.core.consumers.functions.GenericFunction;
import com.wynntils.core.consumers.functions.arguments.Argument;
import com.wynntils.core.consumers.functions.arguments.FunctionArguments;
import com.wynntils.utils.type.NamedValue;
import java.util.List;

public final class NamedFunctions {

    public static class NamedValueFunction
    extends GenericFunction<NamedValue> {
        @Override
        public NamedValue getValue(FunctionArguments arguments) {
            return new NamedValue(arguments.getArgument("name").getStringValue(), arguments.getArgument("value").getIntegerValue().intValue());
        }

        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("name", String.class, null), new Argument<Object>("value", Number.class, null)));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("named");
        }
    }

    public static class ValueFunction
    extends GenericFunction<Double> {
        @Override
        public Double getValue(FunctionArguments arguments) {
            return arguments.getArgument("named").getNamedValue().value();
        }

        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("named", NamedValue.class, null)));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("val");
        }
    }

    public static class NameFunction
    extends GenericFunction<String> {
        @Override
        public String getValue(FunctionArguments arguments) {
            return arguments.getArgument("named").getNamedValue().name();
        }

        @Override
        public FunctionArguments.RequiredArgumentBuilder getRequiredArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("named", NamedValue.class, null)));
        }
    }
}

