/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.container;

import com.google.common.collect.ImmutableList;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handler;
import com.wynntils.handlers.container.ContainerQueryException;
import com.wynntils.handlers.container.ContainerQueryStep;
import com.wynntils.handlers.container.type.ContainerContent;
import com.wynntils.handlers.container.type.ContainerContentChangeType;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.mc.event.ContainerSetSlotEvent;
import com.wynntils.mc.event.LocalSoundEvent;
import com.wynntils.mc.event.MenuEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.wynn.ItemUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;

public final class ContainerQueryHandler
extends Handler {
    private static final int NO_CONTAINER = -2;
    private static final int OPERATION_TIMEOUT_TICKS = 60;
    private static final int NEXT_OPERATION_DELAY_TICKS = 5;
    private static final String MENU_CLICK_SOUND = "minecraft.block.wooden_pressure_plate.click_on";
    private final LinkedList<ContainerQueryStep> queuedQueries = new LinkedList();
    private ContainerQueryStep currentStep;
    private String firstStepName;
    private Component currentTitle;
    private MenuType<?> currentMenuType;
    private ContainerContent currentContent;
    private int containerId = -2;
    private int lastHandledContentId = -2;
    private List<ItemStack> lastHandledItems = List.of();
    private int ticksRemaining;
    private int ticksUntilNextOperation = -1;

    public void runQuery(ContainerQueryStep firstStep) {
        if (this.currentStep != null) {
            boolean alreadyRunning = this.currentStep.getName().equals(firstStep.getName());
            boolean alreadyQueued = this.queuedQueries.stream().anyMatch(query -> query.getName().equals(firstStep.getName()));
            if (alreadyRunning || alreadyQueued) {
                return;
            }
            this.queuedQueries.add(firstStep);
            return;
        }
        Screen screen = McUtils.screen();
        if (screen instanceof AbstractContainerScreen) {
            firstStep.onError("Another container screen is already open");
            return;
        }
        if (McUtils.containerMenu().containerId != 0) {
            firstStep.onError("Another container is already open");
            return;
        }
        this.currentStep = firstStep;
        this.firstStepName = firstStep.getName();
        this.resetTimer();
        try {
            if (!firstStep.startStep(null)) {
                this.endQuery();
            }
        }
        catch (Throwable t) {
            this.raiseError("Cannot execute first step: " + t.getMessage());
        }
    }

    public void endAllQueries() {
        if (this.containerId != -2) {
            McUtils.sendPacket(new ServerboundContainerClosePacket(this.containerId));
            this.raiseError("Container query interrupted by user");
        }
        for (ContainerQueryStep queuedQuery : this.queuedQueries) {
            queuedQuery.onError("Container query interrupted by user");
        }
        this.queuedQueries.clear();
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (event.getNewState() == WorldState.WORLD) {
            return;
        }
        for (ContainerQueryStep queuedQuery : this.queuedQueries) {
            queuedQuery.onError("Container query interrupted by world state change");
        }
        this.queuedQueries.clear();
    }

    @SubscribeEvent
    public void onSound(LocalSoundEvent.Client e) {
        if (this.currentStep == null) {
            return;
        }
        if (e.getSource() != SoundSource.BLOCKS) {
            return;
        }
        if (!e.getSound().location().toLanguageKey().equals(MENU_CLICK_SOUND)) {
            return;
        }
        e.setCanceled(true);
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (this.currentStep == null) {
            return;
        }
        if (this.ticksUntilNextOperation >= 0) {
            --this.ticksUntilNextOperation;
            if (this.ticksUntilNextOperation == 0) {
                try {
                    this.ticksUntilNextOperation = -1;
                    if (this.currentStep.startStep(this.currentContent)) {
                        return;
                    }
                }
                catch (Throwable t) {
                    McUtils.sendPacket(new ServerboundContainerClosePacket(this.containerId));
                    this.raiseError("Error while processing content for " + this.firstStepName + ": " + t.getMessage());
                    return;
                }
                this.endQuery();
                McUtils.sendPacket(new ServerboundContainerClosePacket(this.containerId));
                if (!this.queuedQueries.isEmpty()) {
                    this.runQuery(this.queuedQueries.pop());
                }
            }
            return;
        }
        --this.ticksRemaining;
        if (this.ticksRemaining <= 0) {
            McUtils.sendPacket(new ServerboundContainerClosePacket(this.containerId));
            this.raiseError("Container reply timed out");
        }
    }

    @SubscribeEvent
    public void onMenuOpened(MenuEvent.MenuOpenedEvent.Pre e) {
        if (this.currentStep == null) {
            return;
        }
        if (this.currentStep.verifyContainer(e.getTitle(), e.getMenuType())) {
            this.containerId = e.getContainerId();
            this.currentTitle = e.getTitle();
            this.currentMenuType = e.getMenuType();
            this.resetTimer();
            e.setCanceled(true);
        } else {
            McUtils.sendPacket(new ServerboundContainerClosePacket(this.containerId));
            this.raiseError("Unexpected container opened: '" + e.getTitle().getString() + "'");
        }
    }

    @SubscribeEvent
    public void onMenuForcefullyClosed(MenuEvent.MenuClosedEvent e) {
        if (this.currentStep == null) {
            return;
        }
        if (e.getContainerId() == this.containerId) {
            this.raiseError("Server closed container");
        } else {
            WynntilsMod.warn("Server closed container " + e.getContainerId() + " but we are querying " + this.containerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onContainerSetContent(ContainerSetContentEvent.Pre e) {
        if (this.currentStep == null) {
            return;
        }
        if (e.getContainerId() == 0) {
            return;
        }
        if (this.containerId == -2) {
            return;
        }
        int id = e.getContainerId();
        if (id != this.containerId) {
            this.raiseError("Another container opened");
            return;
        }
        if (this.ticksUntilNextOperation >= 0) {
            return;
        }
        if (this.containerId == this.lastHandledContentId && ItemUtils.isItemListsEqual(e.getItems(), this.lastHandledItems)) {
            e.setCanceled(true);
            this.resetTimer();
            return;
        }
        this.lastHandledContentId = this.containerId;
        this.lastHandledItems = e.getItems();
        this.currentContent = new ContainerContent((List<ItemStack>)ImmutableList.copyOf(e.getItems()), this.currentTitle, this.currentMenuType, this.containerId);
        this.resetTimer();
        try {
            Int2ObjectArrayMap changeMap = new Int2ObjectArrayMap();
            e.getItems().forEach(itemStack -> changeMap.put(changeMap.size(), itemStack));
            if (this.currentStep.verifyContentChange(this.currentContent, (Int2ObjectMap<ItemStack>)changeMap, ContainerContentChangeType.SET_CONTENT)) {
                this.processContainer(this.currentContent);
            }
        }
        catch (Throwable t) {
            McUtils.sendPacket(new ServerboundContainerClosePacket(this.containerId));
            this.raiseError("Error while processing content for " + this.firstStepName + ": " + t.getMessage());
        }
        finally {
            e.setCanceled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onContainerSetSlot(ContainerSetSlotEvent.Pre e) {
        if (this.currentStep == null) {
            return;
        }
        if (e.getContainerId() == 0) {
            return;
        }
        if (e.getContainerId() == -1) {
            return;
        }
        if (this.containerId == -2) {
            return;
        }
        int id = e.getContainerId();
        if (id != this.containerId) {
            this.raiseError("Another container opened #2");
            return;
        }
        if (this.ticksUntilNextOperation >= 0) {
            return;
        }
        this.lastHandledContentId = this.containerId;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(this.currentContent.items());
        items.set(e.getSlot(), e.getItemStack());
        this.currentContent = new ContainerContent((List<ItemStack>)ImmutableList.copyOf(items), this.currentTitle, this.currentMenuType, this.containerId);
        this.resetTimer();
        try {
            Int2ObjectArrayMap changeMap = new Int2ObjectArrayMap();
            changeMap.put(e.getSlot(), (Object)e.getItemStack());
            if (this.currentStep.verifyContentChange(this.currentContent, (Int2ObjectMap<ItemStack>)changeMap, ContainerContentChangeType.SET_SLOT)) {
                this.processContainer(this.currentContent);
            }
        }
        catch (Throwable t) {
            McUtils.sendPacket(new ServerboundContainerClosePacket(this.containerId));
            this.raiseError("Error while processing set slot for " + this.firstStepName + ": " + t.getMessage());
        }
        finally {
            e.setCanceled(true);
        }
    }

    private void processContainer(ContainerContent currentContainer) throws ContainerQueryException {
        this.currentStep.handleContent(currentContainer);
        ContainerQueryStep nextStep = this.currentStep.getNextStep(currentContainer);
        if (nextStep != null) {
            this.currentStep = nextStep;
            this.ticksUntilNextOperation = 5;
        } else {
            this.endQuery();
            McUtils.sendPacket(new ServerboundContainerClosePacket(this.containerId));
            if (!this.queuedQueries.isEmpty()) {
                this.runQuery(this.queuedQueries.pop());
            }
        }
    }

    private void raiseError(String errorMsg) {
        if (this.currentStep == null) {
            WynntilsMod.error("Internal error in ContainerQueryManager: handleError called with no currentStep");
            return;
        }
        this.currentStep.onError(errorMsg);
        this.endQuery();
        if (!this.queuedQueries.isEmpty()) {
            this.runQuery(this.queuedQueries.pop());
        }
    }

    private void endQuery() {
        this.containerId = -2;
        this.lastHandledContentId = -2;
        this.lastHandledItems = List.of();
        this.currentStep = null;
        this.currentContent = null;
        this.ticksUntilNextOperation = -1;
    }

    private void resetTimer() {
        this.ticksRemaining = 60;
    }
}

