/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.particle;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handler;
import com.wynntils.handlers.particle.event.ParticleVerifiedEvent;
import com.wynntils.handlers.particle.type.Particle;
import com.wynntils.handlers.particle.type.ParticleType;
import com.wynntils.handlers.particle.type.ParticleVerifier;
import com.wynntils.handlers.particle.type.UnverifiedParticle;
import com.wynntils.mc.event.ParticleAddedEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Position;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;

public final class ParticleHandler
extends Handler {
    private final Map<ParticleType, ParticleVerifier> particleVerifiers = new EnumMap<ParticleType, ParticleVerifier>(ParticleType.class);
    private final Set<UnverifiedParticle> unverifiedParticles = new HashSet<UnverifiedParticle>();

    @SubscribeEvent
    public void onParticleAdded(ParticleAddedEvent event) {
        Vec3 particlePosition = new Vec3(event.getX(), event.getY(), event.getZ());
        if (this.unverifiedParticles.isEmpty()) {
            for (ParticleType particleType : this.particleVerifiers.keySet()) {
                UnverifiedParticle unverifiedParticleOfType;
                if (!particleType.getCompatibleParticleEffect().equals((Object)event.getParticle()) || !(unverifiedParticleOfType = new UnverifiedParticle(particleType, event.getParticle())).addNewParticle((Position)particlePosition, event.getParticle())) continue;
                this.unverifiedParticles.add(unverifiedParticleOfType);
            }
        } else {
            ArrayList<UnverifiedParticle> invalidParticles = new ArrayList<UnverifiedParticle>();
            for (UnverifiedParticle unverifiedParticle : this.unverifiedParticles) {
                if (!unverifiedParticle.getParticleEffect().equals((Object)event.getParticle())) continue;
                if (unverifiedParticle.addNewParticle((Position)particlePosition, event.getParticle())) {
                    ParticleVerifier.VerificationResult verificationResult = unverifiedParticle.verifyCompleteness();
                    switch (verificationResult) {
                        case VERIFIED: {
                            Particle particle = unverifiedParticle.getParticle();
                            WynntilsMod.postEvent(new ParticleVerifiedEvent(particle));
                            this.unverifiedParticles.clear();
                            return;
                        }
                        case UNVERIFIED: {
                            break;
                        }
                        case INVALID: {
                            invalidParticles.add(unverifiedParticle);
                        }
                    }
                    continue;
                }
                invalidParticles.add(unverifiedParticle);
            }
            invalidParticles.forEach(this.unverifiedParticles::remove);
        }
    }

    public void registerParticleVerifier(ParticleType particleType, ParticleVerifier particleVerifier) {
        this.particleVerifiers.put(particleType, particleVerifier);
    }

    public ParticleVerifier getParticleVerifier(ParticleType particleType) {
        return this.particleVerifiers.get((Object)particleType);
    }
}

