/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.tooltip.type.TooltipIdentificationDecorator;
import com.wynntils.handlers.tooltip.type.TooltipStyle;
import com.wynntils.handlers.tooltip.type.TooltipWeightDecorator;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.gear.type.ItemWeightSource;
import com.wynntils.models.stats.type.StatListOrdering;
import com.wynntils.models.wynnitem.parsing.WynnItemParser;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public abstract class TooltipBuilder {
    private static final TooltipStyle DEFAULT_TOOLTIP_STYLE = new TooltipStyle(StatListOrdering.WYNNCRAFT, false, false, true, true);
    private final List<Component> header;
    private final List<Component> footer;
    private final String source;
    private ClassType cachedCurrentClass;
    private ItemWeightSource cachedWeightSource;
    private TooltipStyle cachedStyle;
    private TooltipIdentificationDecorator cachedIdentificationDecorator;
    private TooltipWeightDecorator cachedWeightDecorator;
    private List<Component> identificationsCache;
    private List<Component> weightedHeaderCache;

    protected TooltipBuilder(List<Component> header, List<Component> footer, String source) {
        this.header = header;
        this.footer = footer;
        this.source = source;
    }

    public List<Component> getTooltipLines(ClassType currentClass) {
        return this.getTooltipLines(currentClass, DEFAULT_TOOLTIP_STYLE, null, ItemWeightSource.NONE, null);
    }

    public List<Component> getTooltipLines(ClassType currentClass, TooltipStyle style, TooltipIdentificationDecorator identificationDecorator, ItemWeightSource weightSource, TooltipWeightDecorator weightDecorator) {
        ArrayList<Component> tooltip;
        if (!(currentClass == this.cachedCurrentClass && this.cachedWeightSource == weightSource && Objects.equals(this.cachedStyle, style) && Objects.equals(this.cachedIdentificationDecorator, identificationDecorator) && Objects.equals(this.cachedWeightDecorator, weightDecorator))) {
            List<Component> identifications = this.getIdentificationLines(currentClass, style, identificationDecorator);
            this.identificationsCache = identifications;
            this.cachedCurrentClass = currentClass;
            this.cachedWeightSource = weightSource;
            this.cachedStyle = style;
            this.cachedIdentificationDecorator = identificationDecorator;
            this.cachedWeightDecorator = weightDecorator;
            List<Component> weightings = null;
            if (weightSource != ItemWeightSource.NONE) {
                weightings = this.getWeightedHeaderLines(this.header, weightSource, weightDecorator, style);
            }
            this.weightedHeaderCache = weightings;
        }
        if (weightSource != ItemWeightSource.NONE) {
            if (this.weightedHeaderCache == null) {
                this.weightedHeaderCache = this.getWeightedHeaderLines(this.header, weightSource, weightDecorator, style);
            }
            tooltip = new ArrayList<Component>(this.weightedHeaderCache);
        } else {
            tooltip = new ArrayList<Component>(this.header);
        }
        tooltip.addAll(this.identificationsCache);
        tooltip.addAll(this.footer);
        if (!this.source.isEmpty()) {
            tooltip.add(1, (Component)Component.literal((String)this.source).withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC));
        }
        return tooltip;
    }

    protected abstract List<Component> getWeightedHeaderLines(List<Component> var1, ItemWeightSource var2, TooltipWeightDecorator var3, TooltipStyle var4);

    protected abstract List<Component> getIdentificationLines(ClassType var1, TooltipStyle var2, TooltipIdentificationDecorator var3);

    protected static Pair<List<Component>, List<Component>> extractHeaderAndFooter(List<Component> lore) {
        ArrayList<Component> header = new ArrayList<Component>();
        ArrayList<Object> footer = new ArrayList<Object>();
        boolean headerEnded = false;
        boolean footerStarted = false;
        boolean skillPointsStarted = false;
        boolean foundSkills = false;
        boolean foundIdentifications = false;
        for (Component loreLine : lore) {
            StyledText codedLine = StyledText.fromComponent(loreLine).getNormalized();
            if (!footerStarted) {
                if (codedLine.matches(WynnItemParser.SET_BONUS_PATTERN)) {
                    headerEnded = true;
                    footerStarted = true;
                } else {
                    Matcher matcher = codedLine.getMatcher(WynnItemParser.IDENTIFICATION_STAT_PATTERN);
                    if (matcher.matches()) {
                        skillPointsStarted = false;
                        String statName = matcher.group(6);
                        if (Skill.isSkill(statName)) {
                            skillPointsStarted = true;
                            foundSkills = true;
                        } else {
                            foundIdentifications = true;
                        }
                        headerEnded = true;
                        continue;
                    }
                    if (skillPointsStarted) {
                        skillPointsStarted = false;
                        continue;
                    }
                }
            }
            if (!headerEnded) {
                header.add(loreLine);
                continue;
            }
            footerStarted = true;
            footer.add(loreLine);
        }
        if (foundSkills && !foundIdentifications) {
            footer.addFirst(Component.literal((String)""));
        }
        return Pair.of(header, footer);
    }
}

