/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.mc.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.wynntils.core.events.MixinHelper;
import com.wynntils.mc.event.PlayerRenderLayerEvent;
import com.wynntils.mc.event.RenderTranslucentCheckEvent;
import com.wynntils.utils.colors.CommonColors;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CapeLayer.class})
public abstract class CapeLayerMixin {
    @Shadow
    @Final
    private HumanoidModel<PlayerRenderState> model;
    @Unique
    private float wynntilsTranslucence;

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/renderer/entity/state/PlayerRenderState;FF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, PlayerRenderState playerRenderState, float f, float g, CallbackInfo ci) {
        PlayerRenderLayerEvent.Cape event = new PlayerRenderLayerEvent.Cape(playerRenderState);
        MixinHelper.post(event);
        if (event.isCanceled()) {
            ci.cancel();
        }
    }

    @ModifyArg(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/renderer/entity/state/PlayerRenderState;FF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource;getBuffer(Lnet/minecraft/client/renderer/RenderType;)Lcom/mojang/blaze3d/vertex/VertexConsumer;"))
    private RenderType setTranslucenceCapeRenderType(RenderType original, @Local(argsOnly=true) PlayerRenderState playerRenderState, @Local PlayerSkin playerSkin) {
        float translucence;
        RenderTranslucentCheckEvent.Cape event = new RenderTranslucentCheckEvent.Cape(false, (LivingEntityRenderState)playerRenderState, 1.0f);
        MixinHelper.post(event);
        this.wynntilsTranslucence = translucence = event.getTranslucence();
        return event.isTranslucent() ? RenderType.entityTranslucent((ResourceLocation)playerSkin.capeTexture()) : original;
    }

    @WrapOperation(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/renderer/entity/state/PlayerRenderState;FF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/HumanoidModel;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V")})
    private void setTranslucenceCapeRenderType(HumanoidModel<?> instance, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, Operation<Void> original) {
        if (this.wynntilsTranslucence == 1.0f) {
            original.call(new Object[]{instance, poseStack, buffer, packedLight, packedOverlay});
            return;
        }
        this.model.renderToBuffer(poseStack, buffer, packedLight, packedOverlay, CommonColors.WHITE.withAlpha(this.wynntilsTranslucence).asInt());
    }
}

