/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.abilities.type;

import net.minecraft.ChatFormatting;

public class OphanimOrb {
    private final HealthState healthState;

    public OphanimOrb(HealthState healthState) {
        this.healthState = healthState;
    }

    public int getHealthState() {
        return switch (this.healthState.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 3;
            case 1 -> 2;
            case 2 -> 1;
            case 3 -> 0;
        };
    }

    public String getString() {
        return this.healthState.getColor().toString() + "\u23fa";
    }

    public static enum HealthState {
        HEALTHY(ChatFormatting.AQUA),
        DAMAGED(ChatFormatting.YELLOW),
        DYING(ChatFormatting.RED),
        DEAD(ChatFormatting.GRAY);

        private final ChatFormatting color;

        private HealthState(ChatFormatting color) {
            this.color = color;
        }

        public static HealthState fromColor(ChatFormatting color) {
            for (HealthState value : HealthState.values()) {
                if (value.getColor() != color) continue;
                return value;
            }
            return null;
        }

        public ChatFormatting getColor() {
            return this.color;
        }
    }
}

