/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.characterstats.actionbar.matchers;

import com.wynntils.core.WynntilsMod;
import com.wynntils.handlers.actionbar.ActionBarSegment;
import com.wynntils.handlers.actionbar.ActionBarSegmentMatcher;
import com.wynntils.models.characterstats.actionbar.segments.PowderSpecialSegment;
import com.wynntils.models.characterstats.type.PowderSpecialInfo;
import com.wynntils.models.elements.type.Powder;
import com.wynntils.utils.type.Pair;
import java.lang.invoke.StringConcatFactory;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PowderSpecialSegmentMatcher
implements ActionBarSegmentMatcher {
    private static final String SEGMENT_START = "(\udaff\udfef\udaff\udfff\u0001|\udaff\udff0)";
    private static final String SEGMENT_END = "(\udaff\udfee|\udaff\udfef)";
    private static final String EMPTY_POWDER_SPECIAL = "\ue010";
    private static final Map<Powder, Pair<Character, Character>> POWDER_SPECIAL_MAP = Map.of(Powder.AIR, Pair.of(Character.valueOf('\ue020'), Character.valueOf('\ue029')), Powder.EARTH, Pair.of(Character.valueOf('\ue030'), Character.valueOf('\ue039')), Powder.FIRE, Pair.of(Character.valueOf('\ue040'), Character.valueOf('\ue049')), Powder.THUNDER, Pair.of(Character.valueOf('\ue050'), Character.valueOf('\ue059')), Powder.WATER, Pair.of(Character.valueOf('\ue060'), Character.valueOf('\ue069')));
    private static final Pattern POWDER_SPECIAL_REGEX = Pattern.compile((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0002\u0001\ue010])(\udaff\udfee|\udaff\udfef)", "(\udaff\udfef\udaff\udfff\u0001|\udaff\udff0)(?<powder>["}, (String)String.join((CharSequence)"", (CharSequence[])Arrays.stream(Powder.values()).map(POWDER_SPECIAL_MAP::get).map(pair -> String.valueOf(pair.a()) + "-" + String.valueOf(pair.b())).toArray(String[]::new)))));

    @Override
    public ActionBarSegment parse(String actionBar) {
        Matcher matcher = POWDER_SPECIAL_REGEX.matcher(actionBar);
        if (!matcher.find()) {
            return null;
        }
        PowderSpecialInfo powderSpecialInfo = this.getPowderSpecialInfo(matcher.group("powder"));
        return new PowderSpecialSegment(matcher.group(), powderSpecialInfo);
    }

    private PowderSpecialInfo getPowderSpecialInfo(String powderSpecialText) {
        if (powderSpecialText.equals(EMPTY_POWDER_SPECIAL)) {
            return PowderSpecialInfo.EMPTY;
        }
        for (Powder powder : Powder.values()) {
            Pair<Character, Character> powderSpecialRange = POWDER_SPECIAL_MAP.get((Object)powder);
            if (powderSpecialRange == null) {
                WynntilsMod.warn("No range found for powder special: " + String.valueOf((Object)powder));
                continue;
            }
            char powderSpecialChar = powderSpecialText.charAt(0);
            if (powderSpecialChar < powderSpecialRange.a().charValue() || powderSpecialChar > powderSpecialRange.b().charValue()) continue;
            int powderIndex = powderSpecialChar - powderSpecialRange.a().charValue();
            return new PowderSpecialInfo((float)(powderIndex + 1) * 0.1f, powder);
        }
        WynntilsMod.warn("Couldn't find powder special for character: " + powderSpecialText);
        return PowderSpecialInfo.EMPTY;
    }
}

