/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.elements.type;

import com.wynntils.models.elements.type.Element;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.CustomColor;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public enum Powder {
    EARTH(Element.EARTH, Items.LIME_DYE, Items.GREEN_DYE, ChatFormatting.DARK_GREEN, ChatFormatting.GREEN, "Quake"),
    THUNDER(Element.THUNDER, Items.YELLOW_DYE, Items.ORANGE_DYE, ChatFormatting.YELLOW, ChatFormatting.GOLD, "Chain Lightning"),
    WATER(Element.WATER, Items.LIGHT_BLUE_DYE, Items.CYAN_DYE, ChatFormatting.AQUA, ChatFormatting.DARK_AQUA, "Curse"),
    FIRE(Element.FIRE, Items.PINK_DYE, Items.RED_DYE, ChatFormatting.RED, ChatFormatting.DARK_RED, "Courage"),
    AIR(Element.AIR, Items.GRAY_DYE, Items.LIGHT_GRAY_DYE, ChatFormatting.WHITE, ChatFormatting.GRAY, "Wind Prison");

    private final Element element;
    private final Item lowTierItem;
    private final Item highTierItem;
    private final ChatFormatting lightColor;
    private final ChatFormatting darkColor;
    private final String specialName;

    private Powder(Element element, Item lowTierItem, Item highTierItem, ChatFormatting lightColor, ChatFormatting darkColor, String specialName) {
        this.element = element;
        this.lowTierItem = lowTierItem;
        this.highTierItem = highTierItem;
        this.lightColor = lightColor;
        this.darkColor = darkColor;
        this.specialName = specialName;
    }

    public static Powder fromElement(Element element) {
        for (Powder powder : Powder.values()) {
            if (powder.element != element) continue;
            return powder;
        }
        return null;
    }

    public static Powder getFromSymbol(String symbol) {
        Element element = Element.fromSymbol(symbol);
        return Powder.fromElement(element);
    }

    public Element getElement() {
        return this.element;
    }

    public char getSymbol() {
        return this.element.getSymbol().charAt(0);
    }

    public CustomColor getColor() {
        return CustomColor.fromInt(this.lightColor.getColor()).withAlpha(255);
    }

    public Item getLowTierItem() {
        return this.lowTierItem;
    }

    public Item getHighTierItem() {
        return this.highTierItem;
    }

    public ChatFormatting getLightColor() {
        return this.lightColor;
    }

    public ChatFormatting getDarkColor() {
        return this.darkColor;
    }

    public String getSpecialName() {
        return this.specialName;
    }

    public String getName() {
        return StringUtils.capitalizeFirst(this.name().toLowerCase(Locale.ROOT));
    }
}

