/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.emeralds;

import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.mc.event.ContainerCloseEvent;
import com.wynntils.mc.event.MenuEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.emeralds.type.EmeraldUnits;
import com.wynntils.models.items.items.game.EmeraldPouchItem;
import com.wynntils.models.items.properties.EmeraldValuedItemProperty;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.utils.mc.McUtils;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;

public final class EmeraldModel
extends Model {
    public static final int EMERALD_BLOCK_VALUE = 64;
    public static final int LIQUID_EMERALD_VALUE = 4096;
    public static final int LIQUID_EMERALD_STACK_VALUE = 262144;
    private static final Pattern STX_PATTERN = Pattern.compile("(\\.?\\d+\\.?\\d*)\\s*(s|stx|stacks)");
    private static final Pattern LE_PATTERN = Pattern.compile("(\\.?\\d+\\.?\\d*)\\s*(l|le)");
    private static final Pattern EB_PATTERN = Pattern.compile("(\\.?\\d+\\.?\\d*)\\s*(b|eb)");
    private static final Pattern K_PATTERN = Pattern.compile("(\\.?\\d+\\.?\\d*)\\s*(k|thousand)");
    private static final Pattern M_PATTERN = Pattern.compile("(\\.?\\d+\\.?\\d*)\\s*(m|million)");
    private static final Pattern E_PATTERN = Pattern.compile("(\\d+)($|-t|\\s|\\s*e|\\s*em)(?![^\\d\\s-])");
    private static final Pattern RAW_PRICE_PATTERN = Pattern.compile("\\d+");
    private static final double SILVERBULL_TAX_AMOUNT = 1.03;
    private static final double NORMAL_TAX_AMOUNT = 1.05;
    private int inventoryEmeralds = 0;
    private int containerEmeralds = 0;

    public EmeraldModel() {
        super(List.of());
    }

    @SubscribeEvent
    public void onWorldChange(WorldStateEvent e) {
        if (e.getNewState() != WorldState.WORLD) {
            return;
        }
        this.inventoryEmeralds = 0;
        this.containerEmeralds = 0;
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        this.recountEmeralds();
    }

    private void recountEmeralds() {
        this.inventoryEmeralds = 0;
        NonNullList items = McUtils.inventoryMenu().getItems();
        for (ItemStack item : items) {
            this.adjustBalance(item, true);
        }
        this.containerEmeralds = 0;
        items = McUtils.containerMenu().getItems();
        for (ItemStack item : items) {
            this.adjustBalance(item, false);
        }
    }

    @SubscribeEvent
    public void onMenuClosed(MenuEvent.MenuClosedEvent e) {
        this.containerEmeralds = 0;
    }

    @SubscribeEvent
    public void onContainerClose(ContainerCloseEvent.Post event) {
        this.containerEmeralds = 0;
    }

    private void adjustBalance(ItemStack newItemStack, boolean isInventory) {
        int adjustValue = 0;
        Optional<EmeraldValuedItemProperty> newItemValueOpt = Models.Item.asWynnItemProperty(newItemStack, EmeraldValuedItemProperty.class);
        if (newItemValueOpt.isPresent()) {
            adjustValue += newItemValueOpt.get().getEmeraldValue();
        }
        if (isInventory) {
            this.inventoryEmeralds += adjustValue;
        } else {
            this.containerEmeralds += adjustValue;
        }
    }

    public String getEmeraldCountString(int emeralds, boolean includeSymbol) {
        return String.format(Locale.ROOT, "%,d" + (includeSymbol ? EmeraldUnits.EMERALD.getSymbol() : ""), emeralds);
    }

    public String getFormattedString(int emeralds, boolean appendZeros) {
        StringBuilder builder = new StringBuilder();
        int[] emeraldAmounts = this.emeraldsPerUnit(emeralds);
        for (int i = emeraldAmounts.length - 1; i >= 0; --i) {
            if (emeraldAmounts[i] == 0 && !appendZeros) continue;
            builder.append(emeraldAmounts[i]).append(EmeraldUnits.values()[i].getSymbol()).append(" ");
        }
        return builder.toString().trim();
    }

    public int[] emeraldsPerUnit(int emeralds) {
        return new int[]{emeralds % 64, emeralds / 64 % 64, emeralds / 4096 % 64, emeralds / 262144};
    }

    public boolean isEmeraldPouch(ItemStack itemStack) {
        Optional<EmeraldPouchItem> itemOpt = Models.Item.asWynnItem(itemStack, EmeraldPouchItem.class);
        return itemOpt.isPresent();
    }

    public int getAmountInInventory() {
        return this.inventoryEmeralds;
    }

    public int getAmountInContainer() {
        return this.containerEmeralds - this.inventoryEmeralds;
    }

    public String convertEmeraldPrice(String inputStr) {
        Matcher rawMatcher = RAW_PRICE_PATTERN.matcher(inputStr);
        if (rawMatcher.matches()) {
            return "";
        }
        String input = inputStr.toLowerCase(Locale.ROOT);
        long emeralds = 0L;
        try {
            Matcher stxMatcher = STX_PATTERN.matcher(input);
            while (stxMatcher.find()) {
                emeralds += (long)(Double.parseDouble(stxMatcher.group(1)) * 262144.0);
            }
            Matcher leMatcher = LE_PATTERN.matcher(input);
            while (leMatcher.find()) {
                emeralds += (long)(Double.parseDouble(leMatcher.group(1)) * 4096.0);
            }
            Matcher ebMatcher = EB_PATTERN.matcher(input);
            while (ebMatcher.find()) {
                emeralds += (long)(Double.parseDouble(ebMatcher.group(1)) * 64.0);
            }
            Matcher kMatcher = K_PATTERN.matcher(input);
            while (kMatcher.find()) {
                emeralds += (long)(Double.parseDouble(kMatcher.group(1)) * 1000.0);
            }
            Matcher mMatcher = M_PATTERN.matcher(input);
            while (mMatcher.find()) {
                emeralds += (long)(Double.parseDouble(mMatcher.group(1)) * 1000000.0);
            }
            Matcher eMatcher = E_PATTERN.matcher(input);
            while (eMatcher.find()) {
                emeralds += Long.parseLong(eMatcher.group(1));
            }
            if (input.contains("-t")) {
                emeralds = Math.round((double)emeralds / this.getTaxAmount());
            }
        }
        catch (NumberFormatException e) {
            return "";
        }
        return emeralds > 0L ? String.valueOf(emeralds) : "";
    }

    public int getWithoutTax(int taxedValue) {
        return (int)Math.ceil((double)taxedValue / Models.Emerald.getTaxAmount());
    }

    public int getWithTax(int untaxedValue) {
        return (int)Math.floor((double)untaxedValue * Models.Emerald.getTaxAmount());
    }

    public double getTaxAmount() {
        return Models.Account.isSilverbullSubscriber() ? 1.03 : 1.05;
    }
}

