/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding.impl.block;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.models.items.encoding.data.CustomIdentificationsData;
import com.wynntils.models.items.encoding.type.DataTransformer;
import com.wynntils.models.items.encoding.type.DataTransformerType;
import com.wynntils.models.items.encoding.type.ItemTransformingVersion;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.utils.UnsignedByteUtils;
import com.wynntils.utils.type.ArrayReader;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.RangedValue;
import com.wynntils.utils.type.UnsignedByte;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class CustomIdentificationDataTransformer
extends DataTransformer<CustomIdentificationsData> {
    @Override
    protected ErrorOr<UnsignedByte[]> encodeData(ItemTransformingVersion version, CustomIdentificationsData data) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.encodeCustomIdentificationData(data);
    }

    @Override
    public ErrorOr<CustomIdentificationsData> decodeData(ItemTransformingVersion version, ArrayReader<UnsignedByte> byteReader) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.decodeCustomIdentificationData(byteReader);
    }

    @Override
    public byte getId() {
        return DataTransformerType.CUSTOM_IDENTIFICATION_DATA_TRANSFORMER.getId();
    }

    private ErrorOr<UnsignedByte[]> encodeCustomIdentificationData(CustomIdentificationsData data) {
        ArrayList<UnsignedByte> bytes = new ArrayList<UnsignedByte>();
        bytes.add(UnsignedByte.of((byte)data.possibleValues().size()));
        for (StatPossibleValues statPossibleValues : data.possibleValues()) {
            Optional<Integer> idOpt = Models.Stat.getIdForStatType(statPossibleValues.statType());
            if (idOpt.isEmpty()) {
                WynntilsMod.warn("No ID found for stat type " + statPossibleValues.statType().getApiName());
                return ErrorOr.error("Unable to encode stat type: " + statPossibleValues.statType().getDisplayName());
            }
            int id = idOpt.get();
            bytes.add(UnsignedByte.of((byte)id));
            UnsignedByte[] unsignedBytes = UnsignedByteUtils.encodeVariableSizedInteger(statPossibleValues.range().high());
            bytes.addAll(List.of(unsignedBytes));
        }
        return ErrorOr.of(bytes.toArray(new UnsignedByte[0]));
    }

    private ErrorOr<CustomIdentificationsData> decodeCustomIdentificationData(ArrayReader<UnsignedByte> byteReader) {
        int numIdentifications = byteReader.read().value();
        ArrayList<StatPossibleValues> possibleValues = new ArrayList<StatPossibleValues>();
        for (int i = 0; i < numIdentifications; ++i) {
            short id = byteReader.read().value();
            Optional<StatType> statTypeOpt = Models.Stat.getStatTypeForId(id);
            if (statTypeOpt.isEmpty()) {
                WynntilsMod.warn("No stat found for id " + id);
                return ErrorOr.error("Unable to decode stat with id " + id);
            }
            StatType statType = statTypeOpt.get();
            int maxValue = (int)UnsignedByteUtils.decodeVariableSizedInteger(byteReader);
            possibleValues.add(new StatPossibleValues(statType, RangedValue.of(Math.round((float)maxValue * 0.1f), maxValue), maxValue, false));
        }
        return ErrorOr.of(new CustomIdentificationsData(possibleValues));
    }
}

