/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding.impl.block;

import com.wynntils.models.items.encoding.data.DurabilityData;
import com.wynntils.models.items.encoding.type.DataTransformer;
import com.wynntils.models.items.encoding.type.DataTransformerType;
import com.wynntils.models.items.encoding.type.ItemTransformingVersion;
import com.wynntils.utils.UnsignedByteUtils;
import com.wynntils.utils.type.ArrayReader;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.UnsignedByte;
import java.util.ArrayList;
import java.util.List;

public class DurablityDataTransformer
extends DataTransformer<DurabilityData> {
    @Override
    protected ErrorOr<UnsignedByte[]> encodeData(ItemTransformingVersion version, DurabilityData data) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.encodeDurablityData(data);
    }

    @Override
    public ErrorOr<DurabilityData> decodeData(ItemTransformingVersion version, ArrayReader<UnsignedByte> byteReader) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.decodeDurabilityData(byteReader);
    }

    @Override
    public byte getId() {
        return DataTransformerType.DURABILITY_DATA_TRANSFORMER.getId();
    }

    private ErrorOr<UnsignedByte[]> encodeDurablityData(DurabilityData data) {
        ArrayList<UnsignedByte> bytes = new ArrayList<UnsignedByte>();
        if (data.effectStrength() > 100 || data.effectStrength() < 0) {
            return ErrorOr.error("Effect strength was not a percentage.");
        }
        bytes.add(UnsignedByte.of((byte)data.effectStrength()));
        int max = data.durability().max();
        UnsignedByte[] unsignedBytes = UnsignedByteUtils.encodeVariableSizedInteger(max);
        bytes.addAll(List.of(unsignedBytes));
        int current = data.durability().current();
        unsignedBytes = UnsignedByteUtils.encodeVariableSizedInteger(current);
        bytes.addAll(List.of(unsignedBytes));
        return ErrorOr.of(bytes.toArray(new UnsignedByte[0]));
    }

    private ErrorOr<DurabilityData> decodeDurabilityData(ArrayReader<UnsignedByte> byteReader) {
        short effectStrength = byteReader.read().value();
        int max = (int)UnsignedByteUtils.decodeVariableSizedInteger(byteReader);
        int current = (int)UnsignedByteUtils.decodeVariableSizedInteger(byteReader);
        return ErrorOr.of(new DurabilityData(effectStrength, new CappedValue(current, max)));
    }
}

