/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding.impl.block;

import com.wynntils.models.items.encoding.data.UsesData;
import com.wynntils.models.items.encoding.type.DataTransformer;
import com.wynntils.models.items.encoding.type.DataTransformerType;
import com.wynntils.models.items.encoding.type.ItemTransformingVersion;
import com.wynntils.utils.type.ArrayReader;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.UnsignedByte;

public class UsesDataTransformer
extends DataTransformer<UsesData> {
    @Override
    protected ErrorOr<UnsignedByte[]> encodeData(ItemTransformingVersion version, UsesData data) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.encodeUsesData(data);
    }

    @Override
    public ErrorOr<UsesData> decodeData(ItemTransformingVersion version, ArrayReader<UnsignedByte> byteReader) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.decodeUsesData(byteReader);
    }

    @Override
    public byte getId() {
        return DataTransformerType.USES_DATA_TRANSFORMER.getId();
    }

    private ErrorOr<UnsignedByte[]> encodeUsesData(UsesData data) {
        if (data.uses().current() < 0 || data.uses().max() < 0 || data.uses().current() > 255 || data.uses().max() > 255) {
            return ErrorOr.error("Uses data does not fit a byte: " + String.valueOf(data.uses()));
        }
        UnsignedByte[] bytes = new UnsignedByte[]{new UnsignedByte((byte)data.uses().current()), new UnsignedByte((byte)data.uses().max())};
        return ErrorOr.of(bytes);
    }

    private ErrorOr<UsesData> decodeUsesData(ArrayReader<UnsignedByte> byteReader) {
        short currentUses = byteReader.read().value();
        short maxUses = byteReader.read().value();
        return ErrorOr.of(new UsesData(new CappedValue(currentUses, maxUses)));
    }
}

