/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.lootrun.particle;

import com.wynntils.handlers.particle.type.Particle;
import com.wynntils.handlers.particle.type.ParticleType;
import com.wynntils.handlers.particle.type.ParticleVerifier;
import java.util.List;
import net.minecraft.core.Position;
import net.minecraft.world.phys.Vec3;

public class LootrunTaskParticleVerifier
implements ParticleVerifier {
    private static final int RADIUS = 5;
    private static final double CIRCLE_RADIUS_WITH_ERROR = 6.0;

    @Override
    public boolean verifyNewPosition(List<Position> positions, Position addedPosition) {
        if (positions.isEmpty()) {
            return LootrunTaskParticleVerifier.isParticlePrecise(addedPosition);
        }
        Position rightParticle = positions.getFirst();
        Vec3 circleCenter = new Vec3(rightParticle.x() - 5.0, rightParticle.y(), rightParticle.z());
        boolean isPartOfCircle = circleCenter.closerThan(addedPosition, 6.0);
        if (!isPartOfCircle) {
            return false;
        }
        if (positions.size() % 5 == 0) {
            return LootrunTaskParticleVerifier.isParticlePrecise(addedPosition);
        }
        return true;
    }

    @Override
    public ParticleVerifier.VerificationResult verifyCompleteness(List<Position> positions) {
        if (positions.size() == 2) {
            Position rightParticle = positions.get(0);
            Position leftParticle = positions.get(1);
            if (LootrunTaskParticleVerifier.isParticlePrecise(rightParticle) && LootrunTaskParticleVerifier.isParticlePrecise(leftParticle)) {
                Vec3 leftParticleVec;
                Vec3 rightParticleVec = new Vec3(rightParticle.x(), rightParticle.y(), rightParticle.z());
                return rightParticleVec.distanceToSqr(leftParticleVec = new Vec3(leftParticle.x(), leftParticle.y(), leftParticle.z())) == 100.0 ? ParticleVerifier.VerificationResult.VERIFIED : ParticleVerifier.VerificationResult.INVALID;
            }
            return ParticleVerifier.VerificationResult.UNVERIFIED;
        }
        if (positions.size() == 20) {
            return ParticleVerifier.VerificationResult.VERIFIED;
        }
        if (positions.size() > 20) {
            return ParticleVerifier.VerificationResult.INVALID;
        }
        return ParticleVerifier.VerificationResult.UNVERIFIED;
    }

    @Override
    public Particle getParticle(List<Position> positions) {
        Position rightParticle = positions.getFirst();
        Vec3 verifiedParticlePosition = new Vec3(rightParticle.x() - 5.0, rightParticle.y(), rightParticle.z());
        return new Particle((Position)verifiedParticlePosition, ParticleType.LOOTRUN_TASK);
    }

    private static boolean isParticlePrecise(Position addedPosition) {
        return Math.abs(addedPosition.x() % 0.5) == 0.0 && Math.abs(addedPosition.z() % 0.5) == 0.0;
    }
}

