/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.players.type;

import com.wynntils.utils.mc.ComponentUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public enum AccountType {
    NORMAL(null),
    BANNED(null),
    DONATOR(Component.literal((String)"Wynntils Donator")),
    CONTENT_TEAM(Component.literal((String)"Wynntils CT").withStyle(ChatFormatting.DARK_AQUA)),
    TRANSLATOR(Component.literal((String)"Wynntils Translator").withStyle(ChatFormatting.DARK_AQUA)),
    HELPER(Component.literal((String)"Wynntils Helper").withStyle(ChatFormatting.GREEN)),
    SUPPORT(Component.literal((String)"Wynntils Support").withStyle(ChatFormatting.GREEN)),
    MODERATOR(Component.literal((String)"Wynntils Moderator").withStyle(ChatFormatting.BLUE)),
    DEVELOPER(Component.literal((String)"Wynntils Developer").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.BOLD)),
    ADMIN(Component.literal((String)"Wynntils Admin").withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.BOLD));

    private final MutableComponent component;

    private AccountType(MutableComponent component) {
        this.component = component;
    }

    public MutableComponent getComponent() {
        if (this == DONATOR) {
            return ComponentUtils.makeRainbowStyle(this.component.getString(), false);
        }
        if (this == MODERATOR) {
            return DEVELOPER.getComponent();
        }
        return this.component;
    }
}

