/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.profession.label;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.labels.type.LabelParser;
import com.wynntils.models.profession.label.ProfessionGatheringNodeLabelInfo;
import com.wynntils.models.profession.type.MaterialProfile;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.type.Pair;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.world.entity.Entity;

public class GatheringNodeLabelParser
implements LabelParser<ProfessionGatheringNodeLabelInfo> {
    private static final Pattern GATHERING_NODE_LABEL = Pattern.compile("^\u00a7(.)(.+?)(?= Roots| Seed| Fish| Eel)?(?: Roots| Seed| Fish| Eel)?\n\u00a7(a\u2714|c\u2716)\u00a7f .\u00a77 .+ Lv\\. Min: \u00a7f\\d+(\n\n\u00a78Left-Click for .+\nRight-Click for .+)?$");

    @Override
    public ProfessionGatheringNodeLabelInfo getInfo(StyledText label, Location location, Entity entity) {
        if (label.isEmpty()) {
            return null;
        }
        Matcher matcher = label.getMatcher(GATHERING_NODE_LABEL);
        if (matcher.matches()) {
            Optional<Pair<MaterialProfile.MaterialType, MaterialProfile.SourceMaterial>> materialLookup = MaterialProfile.findByMaterialName(matcher.group(2), ChatFormatting.getByCode((char)matcher.group(1).charAt(0)));
            return materialLookup.map(materialTypeSourceMaterialPair -> new ProfessionGatheringNodeLabelInfo(label, matcher.group(2) + " Node", location, entity, (MaterialProfile.SourceMaterial)materialTypeSourceMaterialPair.value(), (MaterialProfile.MaterialType)((Object)((Object)materialTypeSourceMaterialPair.key())))).orElse(null);
        }
        return null;
    }
}

