/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.seaskipper;

import com.google.common.reflect.TypeToken;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.core.net.UrlId;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.SeaskipperContainer;
import com.wynntils.models.items.items.gui.SeaskipperDestinationItem;
import com.wynntils.models.seaskipper.type.SeaskipperDestination;
import com.wynntils.models.seaskipper.type.SeaskipperDestinationProfile;
import com.wynntils.screens.maps.CustomSeaskipperScreen;
import com.wynntils.services.map.pois.SeaskipperDestinationPoi;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.wynn.ContainerUtils;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;

public final class SeaskipperModel
extends Model {
    private static final String BOAT_NAME = "Boat";
    private List<SeaskipperDestination> allDestinations = new ArrayList<SeaskipperDestination>();
    private List<SeaskipperDestination> availableDestinations = new ArrayList<SeaskipperDestination>();
    private int boatSlot = -1;
    private int containerId = -2;

    public SeaskipperModel() {
        super(List.of());
    }

    @Override
    public void registerDownloads(DownloadRegistry registry) {
        registry.registerDownload(UrlId.DATA_STATIC_SEASKIPPER_DESTINATIONS).handleReader(this::handleSeaskipperPois);
    }

    @SubscribeEvent
    public void onScreenInit(ScreenInitEvent.Pre e) {
        Container container = Models.Container.getCurrentContainer();
        if (!(container instanceof SeaskipperContainer)) {
            return;
        }
        SeaskipperContainer seaskipperContainer = (SeaskipperContainer)container;
        this.containerId = seaskipperContainer.getContainerId();
    }

    @SubscribeEvent
    public void onContainerSetContent(ContainerSetContentEvent.Post event) {
        if (event.getContainerId() != this.containerId) {
            return;
        }
        this.availableDestinations = new ArrayList<SeaskipperDestination>();
        for (int i = 0; i < event.getItems().size(); ++i) {
            ItemStack item = event.getItems().get(i);
            if (item.getHoverName().getString().equals(BOAT_NAME)) {
                this.boatSlot = i;
                continue;
            }
            Optional<SeaskipperDestinationItem> optionalItem = Models.Item.asWynnItem(item, SeaskipperDestinationItem.class);
            if (optionalItem.isEmpty()) continue;
            SeaskipperDestinationItem destinationItem = optionalItem.get();
            Optional<SeaskipperDestination> destinationOptional = this.allDestinations.stream().filter(profile -> profile.profile().destination().equals(destinationItem.getDestination())).findFirst();
            if (destinationOptional.isEmpty()) {
                WynntilsMod.warn("Could not find profile for destination: " + destinationItem.getDestination());
                continue;
            }
            SeaskipperDestinationProfile profile2 = destinationOptional.get().profile();
            this.availableDestinations.add(new SeaskipperDestination(profile2, destinationItem, i));
        }
        Screen screen = McUtils.screen();
        if (screen instanceof CustomSeaskipperScreen) {
            CustomSeaskipperScreen customSeaskipperScreen = (CustomSeaskipperScreen)screen;
            customSeaskipperScreen.reloadDestinationPois();
        }
    }

    public List<SeaskipperDestinationPoi> getPois(boolean includeAll) {
        ArrayList<SeaskipperDestinationPoi> pois = new ArrayList<SeaskipperDestinationPoi>();
        for (SeaskipperDestination destination : this.availableDestinations) {
            pois.add(new SeaskipperDestinationPoi(destination));
        }
        this.allDestinations.stream().filter(SeaskipperDestination::isPlayerInside).findFirst().ifPresent(profile -> pois.add(new SeaskipperDestinationPoi((SeaskipperDestination)profile)));
        if (includeAll) {
            List<SeaskipperDestination> notAvailableProfiles = this.allDestinations.stream().filter(profile -> pois.stream().map(SeaskipperDestinationPoi::getDestination).noneMatch(destination -> destination.profile().equals(profile.profile()))).toList();
            pois.addAll(notAvailableProfiles.stream().map(SeaskipperDestinationPoi::new).toList());
        }
        return pois;
    }

    public void purchaseBoat() {
        ContainerUtils.clickOnSlot(this.boatSlot, this.containerId, 0, (List<ItemStack>)McUtils.containerMenu().getItems());
    }

    public void purchasePass(SeaskipperDestination destination) {
        if (destination.slot() == -1) {
            return;
        }
        ContainerUtils.clickOnSlot(destination.slot(), this.containerId, 0, (List<ItemStack>)McUtils.containerMenu().getItems());
    }

    public boolean isProfileLoaded() {
        return !this.allDestinations.isEmpty();
    }

    private void handleSeaskipperPois(Reader reader) {
        Type type = new TypeToken<ArrayList<SeaskipperDestinationProfile>>(){}.getType();
        List profiles = (List)WynntilsMod.GSON.fromJson(reader, type);
        this.allDestinations = profiles.stream().map(profile -> new SeaskipperDestination((SeaskipperDestinationProfile)profile, null, -1)).toList();
    }
}

