/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.territories;

import com.wynntils.core.components.Models;
import com.wynntils.models.territories.profile.TerritoryProfile;
import com.wynntils.models.territories.type.GuildResourceValues;
import com.wynntils.utils.mc.McUtils;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Position;

public record TerritoryAttackTimer(String territoryName, long timerEnd) {
    public String asString() {
        Optional<GuildResourceValues> defense = this.defense();
        ChatFormatting defenseColor = defense.isEmpty() ? ChatFormatting.GRAY : defense.get().getDefenceColor();
        String defenseString = defense.isEmpty() ? "Unknown" : defense.get().getAsString();
        TerritoryProfile currentTerritory = Models.Territory.getTerritoryProfileForPosition((Position)McUtils.player().position());
        boolean isCurrentTerritory = currentTerritory != null && currentTerritory.getName().equals(this.territoryName);
        return String.valueOf(ChatFormatting.GRAY) + (String)(isCurrentTerritory ? ChatFormatting.DARK_PURPLE.toString() + String.valueOf(ChatFormatting.BOLD) : "") + this.territoryName + String.valueOf(defenseColor) + " (" + defenseString + ")" + String.valueOf(ChatFormatting.AQUA) + " " + this.timerString();
    }

    public int getMinutesRemaining() {
        return (int)((this.timerEnd - System.currentTimeMillis()) / 60000L);
    }

    public int getSecondsRemaining() {
        return (int)((this.timerEnd - System.currentTimeMillis()) / 1000L) % 60;
    }

    public int asSeconds() {
        return this.getMinutesRemaining() * 60 + this.getSecondsRemaining();
    }

    public String timerString() {
        return "%02d:%02d".formatted(this.getMinutesRemaining(), this.getSecondsRemaining());
    }

    public Optional<GuildResourceValues> defense() {
        return Models.GuildAttackTimer.getDefenseForTerritory(this.territoryName);
    }
}

