/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.territories.type;

import net.minecraft.ChatFormatting;

public enum GuildResource {
    EMERALDS(ChatFormatting.GREEN, "Emeralds", ""),
    ORE(ChatFormatting.WHITE, "Ore", "\u24b7"),
    WOOD(ChatFormatting.GOLD, "Wood", "\u24b8"),
    FISH(ChatFormatting.AQUA, "Fish", "\u24c0"),
    CROPS(ChatFormatting.YELLOW, "Crops", "\u24bf");

    private final ChatFormatting color;
    private final String name;
    private final String symbol;

    private GuildResource(ChatFormatting color, String name, String symbol) {
        this.color = color;
        this.name = name;
        this.symbol = symbol;
    }

    public static GuildResource fromName(String name) {
        for (GuildResource resource : GuildResource.values()) {
            if (!resource.getName().equalsIgnoreCase(name)) continue;
            return resource;
        }
        return null;
    }

    public static GuildResource fromSymbol(String symbol) {
        for (GuildResource resource : GuildResource.values()) {
            if (!resource.getSymbol().equalsIgnoreCase(symbol)) continue;
            return resource;
        }
        return null;
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getName() {
        return this.name;
    }

    public String getPrettySymbol() {
        return String.valueOf(this.color) + this.symbol + (this.symbol.isEmpty() ? "" : " ");
    }

    public boolean isMaterialResource() {
        return this != EMERALDS;
    }
}

