/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.territories.type;

import com.wynntils.models.territories.type.GuildResource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public enum TerritoryUpgrade {
    DAMAGE("Damage", "Increases the damage the tower does", "Damage: +%s%", Items.IRON_SWORD, GuildResource.ORE, new Level[]{new Level(0L, 0.0), new Level(100L, 40.0), new Level(300L, 80.0), new Level(600L, 120.0), new Level(1200L, 160.0), new Level(2400L, 200.0), new Level(4800L, 240.0), new Level(8400L, 280.0), new Level(12000L, 320.0), new Level(15600L, 360.0), new Level(19200L, 400.0), new Level(22800L, 440.0)}),
    ATTACK("Attack", "Increases the rate the tower does an attack", "Attacks per Second: +%s%", Items.RABBIT_HIDE, GuildResource.CROPS, new Level[]{new Level(0L, 0.0), new Level(100L, 50.0), new Level(300L, 100.0), new Level(600L, 150.0), new Level(1200L, 220.0), new Level(2400L, 300.0), new Level(4800L, 400.0), new Level(8400L, 500.0), new Level(12000L, 620.0), new Level(15600L, 660.0), new Level(19200L, 740.0), new Level(22800L, 840.0)}),
    HEALTH("Health", "Increases the health the tower has", "Health: +%s%", Items.FERMENTED_SPIDER_EYE, GuildResource.WOOD, new Level[]{new Level(0L, 0.0), new Level(100L, 50.0), new Level(300L, 100.0), new Level(600L, 150.0), new Level(1200L, 220.0), new Level(2400L, 300.0), new Level(4800L, 400.0), new Level(8400L, 520.0), new Level(12000L, 640.0), new Level(15600L, 760.0), new Level(19200L, 880.0), new Level(22800L, 1000.0)}),
    DEFENCE("Defence", "Increases the defense the tower has", "Defence: +%s%", Items.SHIELD, GuildResource.FISH, new Level[]{new Level(0L, 0.0), new Level(100L, 300.0), new Level(300L, 450.0), new Level(600L, 525.0), new Level(1200L, 600.0), new Level(2400L, 650.0), new Level(4800L, 690.0), new Level(8400L, 720.0), new Level(12000L, 740.0), new Level(15600L, 760.0), new Level(19200L, 780.0), new Level(22800L, 800.0)}),
    STRONGER_MINIONS("Stronger Minions", "Buffs the minions that spawn when your territory is attacked", "Minion Damage: +%s%", Items.SKELETON_SKULL, GuildResource.WOOD, new Level[]{new Level(0L, 0.0), new Level(200L, 150.0), new Level(400L, 200.0), new Level(800L, 250.0), new Level(1600L, 300.0)}),
    TOWER_MULTI_ATTACKS("Tower Multi-Attacks", "Increases the number of players your Guild Tower can attack at once", "Max Targets: %s", Items.ARROW, GuildResource.FISH, new Level[]{new Level(0L, 1.0), new Level(4800L, 2.0)}),
    TOWER_AURA("Tower Aura", "Cast an outward-moving Aura from the Tower and damaging players between 100% and 200% of the Tower's damage.", "Frequency: %ss", Items.ENDER_PEARL, GuildResource.CROPS, new Level[]{new Level(0L, 0.0), new Level(800L, 24.0), new Level(1600L, 18.0), new Level(3200L, 12.0)}),
    TOWER_VOLLEY("Tower Volley", "Cast a volley of fireballs from the Tower damaging players between 100% and 200% of the Tower's damage.", "Frequency: %ss", Items.FIRE_CHARGE, GuildResource.ORE, new Level[]{new Level(0L, 0.0), new Level(200L, 20.0), new Level(400L, 15.0), new Level(800L, 10.0)}),
    GATHERING_EXPERIENCE("Gathering Experience", "Guild members in this territory will gain bonus gathering XP", "Gathering XP: +%s%", Items.CARROT, GuildResource.WOOD, new Level[]{new Level(0L, 0.0), new Level(600L, 10.0), new Level(1300L, 20.0), new Level(2000L, 30.0), new Level(2700L, 40.0), new Level(3400L, 50.0), new Level(5500L, 60.0), new Level(10000L, 80.0), new Level(20000L, 100.0)}),
    MOB_EXPERIENCE("Mob Experience", "Guild members in this territory will receive more XP from mobs", "XP Bonus: +%s%", Items.SUNFLOWER, GuildResource.FISH, new Level[]{new Level(0L, 0.0), new Level(600L, 10.0), new Level(1200L, 20.0), new Level(1800L, 30.0), new Level(2400L, 40.0), new Level(3000L, 50.0), new Level(5000L, 60.0), new Level(10000L, 80.0), new Level(20000L, 100.0)}),
    MOB_DAMAGE("Mob Damage", "Guild members in this territory will deal more damage to mobs", "Damage Bonus: +%s%", Items.STONE_SWORD, GuildResource.CROPS, new Level[]{new Level(0L, 0.0), new Level(600L, 10.0), new Level(1200L, 20.0), new Level(1800L, 40.0), new Level(2400L, 60.0), new Level(3000L, 80.0), new Level(5000L, 120.0), new Level(10000L, 160.0), new Level(20000L, 200.0)}),
    PVP_DAMAGE("PvP Damage", "Guild members in this territory will deal more damage to players", "Damage Bonus: +%s%", Items.GOLDEN_SWORD, GuildResource.ORE, new Level[]{new Level(0L, 0.0), new Level(600L, 5.0), new Level(1200L, 10.0), new Level(1800L, 15.0), new Level(2400L, 20.0), new Level(3000L, 25.0), new Level(5000L, 40.0), new Level(10000L, 65.0), new Level(20000L, 80.0)}),
    XP_SEEKING("XP Seeking", "Your guild will gain XP while holding this territory", "Guild XP: +%s/h", Items.GLOWSTONE_DUST, GuildResource.EMERALDS, new Level[]{new Level(0L, 0.0), new Level(100L, 36000.0), new Level(200L, 66000.0), new Level(400L, 120000.0), new Level(800L, 228000.0), new Level(1600L, 456000.0), new Level(3200L, 900000.0), new Level(6400L, 1740000.0), new Level(9600L, 2580000.0), new Level(12800L, 3360000.0)}),
    TOME_SEEKING("Tome Seeking", "Your guild will have a chance to find exclusive tomes while holding this territory", "Drop Chance: %s%/h", Items.ENCHANTED_BOOK, GuildResource.FISH, new Level[]{new Level(0L, 0.0), new Level(400L, 0.15), new Level(3200L, 1.2), new Level(6400L, 2.4)}),
    EMERALD_SEEKING("Emerald Seeking", "Your guild will have a chance to find emeralds while holding this territory", "Drop Chance: %s%/h", Items.EMERALD_ORE, GuildResource.WOOD, new Level[]{new Level(0L, 0.0), new Level(200L, 0.3), new Level(800L, 3.0), new Level(1600L, 6.0), new Level(3200L, 12.0), new Level(6400L, 24.0)}),
    RESOURCE_STORAGE("Larger Resource Storage", "Increases the storage limit for resources in this territory", "Storage Bonus: +%s%", Items.BREAD, GuildResource.EMERALDS, new Level[]{new Level(0L, 0.0), new Level(400L, 100.0), new Level(800L, 300.0), new Level(2000L, 700.0), new Level(5000L, 1400.0), new Level(16000L, 3300.0), new Level(48000L, 7900.0)}),
    EMERALD_STORAGE("Larger Emerald Storage", "Increases the storage limit for emeralds in this territory", "Storage Bonus: +%s%", Items.EMERALD_BLOCK, GuildResource.WOOD, new Level[]{new Level(0L, 0.0), new Level(200L, 100.0), new Level(400L, 300.0), new Level(1000L, 700.0), new Level(2500L, 1400.0), new Level(8000L, 3300.0), new Level(24000L, 7900.0)}),
    EFFICIENT_RESOURCES("Efficient Resources", "Increases the amount of resources this territory will produce", "Gathering Bonus: +%s%", Items.GOLDEN_PICKAXE, GuildResource.EMERALDS, new Level[]{new Level(0L, 0.0), new Level(6000L, 50.0), new Level(12000L, 100.0), new Level(24000L, 150.0), new Level(48000L, 200.0), new Level(96000L, 250.0), new Level(192000L, 300.0)}),
    RESOURCE_RATE("Resource Rate", "Decreases the time needed to produce resources on this territory", "Gathering Rate: %ss", Items.MUSHROOM_STEM, GuildResource.EMERALDS, new Level[]{new Level(0L, 4.0), new Level(6000L, 3.0), new Level(18000L, 2.0), new Level(32000L, 1.0)}),
    EFFICIENT_EMERALDS("Efficient Emeralds", "Increases the amount of emeralds this territory will produce", "Emerald Bonus: +%s%", Items.EMERALD, GuildResource.ORE, new Level[]{new Level(0L, 0.0), new Level(2000L, 35.0), new Level(8000L, 100.0), new Level(32000L, 300.0)}),
    EMERALD_RATE("Emerald Rate", "Decreases the time needed to produce emeralds on this territory", "Gather Rate: %ss", Items.EXPERIENCE_BOTTLE, GuildResource.CROPS, new Level[]{new Level(0L, 4.0), new Level(2000L, 3.0), new Level(8000L, 2.0), new Level(32000L, 1.0)});

    private final String name;
    private final String description;
    private final String bonusFormat;
    private final Item icon;
    private final GuildResource costResource;
    private final Level[] levels;

    private TerritoryUpgrade(String name, String description, String bonusFormat, Item icon, GuildResource costResource, Level[] levels) {
        this.name = name;
        this.description = description;
        this.bonusFormat = bonusFormat;
        this.icon = icon;
        this.costResource = costResource;
        this.levels = levels;
    }

    public static TerritoryUpgrade fromName(String name) {
        for (TerritoryUpgrade upgrade : TerritoryUpgrade.values()) {
            if (!upgrade.getName().equalsIgnoreCase(name)) continue;
            return upgrade;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getBonusFormat() {
        return this.bonusFormat;
    }

    public Item getIcon() {
        return this.icon;
    }

    public GuildResource getCostResource() {
        return this.costResource;
    }

    public Level[] getLevels() {
        return this.levels;
    }

    public record Level(long cost, double bonus) {
    }
}

