/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;

public class HeldItemCooldownOverlay
extends Overlay {
    public HeldItemCooldownOverlay() {
        super(new OverlayPosition(0.0f, 0.0f, VerticalAlignment.MIDDLE, HorizontalAlignment.CENTER, OverlayPosition.AnchorSection.MIDDLE), new OverlaySize(80.0f, 14.0f));
        this.userEnabled.store(false);
    }

    @Override
    public void render(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        LocalPlayer player = McUtils.player();
        float cooldownPercent = player.getCooldowns().getCooldownPercent(player.getItemInHand(InteractionHand.MAIN_HAND), deltaTracker.getGameTimeDeltaPartialTick(true));
        if (cooldownPercent <= 0.0f) {
            return;
        }
        this.renderOverlay(guiGraphics.pose(), bufferSource, cooldownPercent);
    }

    @Override
    public void renderPreview(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        this.renderOverlay(guiGraphics.pose(), bufferSource, 1.0f);
    }

    private void renderOverlay(PoseStack poseStack, MultiBufferSource bufferSource, float cooldownPercent) {
        float width = this.getWidth();
        float x1 = this.getRenderX();
        float x2 = x1 + width;
        float height = this.getHeight();
        float y = this.getRenderY();
        CustomColor color = CommonColors.WHITE;
        float ym = y + height / 2.0f;
        BufferedRenderUtils.drawLine(poseStack, bufferSource, color, x1, ym, x1 + width * 0.4f, ym, 0.0f, 1.0f);
        BufferedRenderUtils.drawLine(poseStack, bufferSource, color, x2 - width * 0.4f, ym, x2, ym, 0.0f, 1.0f);
        float barWidth = 3.0f;
        float offset = (1.0f - cooldownPercent) * (width - barWidth) / 2.0f;
        BufferedRenderUtils.drawRect(poseStack, bufferSource, color, x1 + offset, y, 0.0f, barWidth, height);
        BufferedRenderUtils.drawRect(poseStack, bufferSource, color, x2 - barWidth - offset, y, 0.0f, barWidth, height);
    }
}

