/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays;

import com.mojang.blaze3d.platform.Window;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.statuseffects.event.StatusEffectsChangedEvent;
import com.wynntils.models.statuseffects.type.StatusEffect;
import com.wynntils.utils.render.TextRenderSetting;
import com.wynntils.utils.render.TextRenderTask;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.neoforged.bus.api.SubscribeEvent;

public class StatusEffectsOverlay
extends Overlay {
    @Persisted
    private final Config<TextShadow> textShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    @Persisted
    private final Config<Float> fontScale = new Config<Float>(Float.valueOf(1.0f));
    @Persisted
    private final Config<StackingBehaviour> stackingBehaviour = new Config<StackingBehaviour>(StackingBehaviour.GROUP);
    @Persisted
    private final Config<Boolean> sortEffects = new Config<Boolean>(true);
    @Persisted
    private final Config<String> ignoredEffects = new Config<String>("");
    private List<TextRenderTask> renderCache = List.of();
    private TextRenderSetting textRenderSetting;

    public StatusEffectsOverlay() {
        super(new OverlayPosition(55.0f, -5.0f, VerticalAlignment.TOP, HorizontalAlignment.RIGHT, OverlayPosition.AnchorSection.TOP_RIGHT), new OverlaySize(250.0f, 110.0f));
        this.updateTextRenderSetting();
    }

    @SubscribeEvent
    public void onStatusChange(StatusEffectsChangedEvent event) {
        this.recalculateRenderCache();
    }

    private void recalculateRenderCache() {
        List<StatusEffect> effects = Models.StatusEffect.getStatusEffects();
        Stream<RenderedStatusEffect> effectWithProperties = this.stackingBehaviour.get() != StackingBehaviour.NONE ? this.stackEffects(effects) : effects.stream().map(x$0 -> new RenderedStatusEffect((StatusEffect)x$0));
        if (((Boolean)this.sortEffects.get()).booleanValue()) {
            effectWithProperties = effectWithProperties.sorted(Comparator.comparing(e -> e.effect));
        }
        this.renderCache = effectWithProperties.map(statusTimer -> new TextRenderTask(statusTimer.getRenderedText(), this.getTextRenderSetting())).toList();
    }

    @Override
    public void render(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        BufferedFontRenderer.getInstance().renderTextsWithAlignment(guiGraphics.pose(), bufferSource, this.getRenderX(), this.getRenderY(), this.renderCache, this.getWidth(), this.getHeight(), this.getRenderHorizontalAlignment(), this.getRenderVerticalAlignment(), ((Float)this.fontScale.get()).floatValue());
    }

    @Override
    public void renderPreview(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        BufferedFontRenderer.getInstance().renderTextsWithAlignment(guiGraphics.pose(), bufferSource, this.getRenderX(), this.getRenderY(), List.of(new TextRenderTask(StyledText.fromString("\u00a78\u2b24 \u00a77 Purification 00:02"), this.textRenderSetting), new TextRenderTask(StyledText.fromString("\u00a78\u2b24 \u00a77 Exploding 01:12"), this.textRenderSetting), new TextRenderTask(StyledText.fromString("\u00a78\u2b24 \u00a77 Thorns 00:12"), this.textRenderSetting), new TextRenderTask(StyledText.fromString("\u00a78\u2b24 \u00a77 Soul Point Regen 00:12"), this.textRenderSetting)), this.getWidth(), this.getHeight(), this.getRenderHorizontalAlignment(), this.getRenderVerticalAlignment(), ((Float)this.fontScale.get()).floatValue());
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        this.updateTextRenderSetting();
        this.recalculateRenderCache();
    }

    private void updateTextRenderSetting() {
        this.textRenderSetting = TextRenderSetting.DEFAULT.withMaxWidth(this.getWidth()).withHorizontalAlignment(this.getRenderHorizontalAlignment()).withTextShadow((TextShadow)this.textShadow.get());
    }

    protected TextRenderSetting getTextRenderSetting() {
        return this.textRenderSetting;
    }

    private Stream<RenderedStatusEffect> stackEffects(List<StatusEffect> effects) {
        List<StatusEffect> filteredEffects = effects;
        if (!((String)this.ignoredEffects.get()).isEmpty()) {
            String[] splitFilters = ((String)this.ignoredEffects.get()).split(",");
            String[] trimmedFilters = (String[])Arrays.stream(splitFilters).map(String::trim).toArray(String[]::new);
            filteredEffects = effects.stream().filter(effect -> Arrays.stream(trimmedFilters).noneMatch(effect.getName().getStringWithoutFormatting()::startsWith)).toList();
        }
        LinkedHashMap<String, RenderedStatusEffect> effectsToRender = new LinkedHashMap<String, RenderedStatusEffect>();
        for (StatusEffect effect2 : filteredEffects) {
            String key = this.getEffectsKey(effect2);
            RenderedStatusEffect entry = (RenderedStatusEffect)effectsToRender.get(key);
            if (entry == null) {
                entry = new RenderedStatusEffect(effect2);
                effectsToRender.put(key, entry);
            }
            entry.setCount(entry.getCount() + 1);
            if (!effect2.hasModifierValue()) continue;
            entry.addModifier(effect2.getModifierValue());
        }
        return effectsToRender.values().stream();
    }

    private String getEffectsKey(StatusEffect effect) {
        return switch (((StackingBehaviour)((Object)this.stackingBehaviour.get())).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> effect.asString().getString();
            case 2 -> effect.getPrefix().getString() + effect.getName().getString() + effect.getModifierSuffix().getString() + effect.getDisplayedTime().getString();
        };
    }

    private static enum StackingBehaviour {
        NONE,
        GROUP,
        SUM;

    }

    private final class RenderedStatusEffect {
        private final StatusEffect effect;
        private int count = 0;
        private final List<Double> modifierList = new ArrayList<Double>();

        private RenderedStatusEffect(StatusEffect effect) {
            this.effect = effect;
        }

        private StyledText getRenderedText() {
            if (this.count <= 1) {
                return this.effect.asString();
            }
            StyledText modifierText = switch (((StackingBehaviour)((Object)StatusEffectsOverlay.this.stackingBehaviour.get())).ordinal()) {
                default -> throw new MatchException(null, null);
                case 2 -> this.getStackedSum();
                case 1 -> this.getStackedGroup();
                case 0 -> StyledText.EMPTY;
            };
            return this.effect.getPrefix().append(StyledText.fromString(" ")).append(modifierText).append(this.effect.getModifierSuffix()).append(StyledText.fromString(" ")).append(this.effect.getName()).append(StyledText.fromString(" ")).append(this.effect.getDisplayedTime());
        }

        private StyledText getStackedSum() {
            if (this.modifierList.isEmpty()) {
                return StyledText.EMPTY;
            }
            double modifierValue = 0.0;
            for (double modifier : this.modifierList) {
                modifierValue += modifier;
            }
            String numberString = (double)Math.round(modifierValue) == modifierValue ? String.format("%+d", (long)modifierValue) : String.format("%+.1f", modifierValue);
            return StyledText.fromString(String.valueOf(ChatFormatting.GRAY) + numberString);
        }

        private StyledText getStackedGroup() {
            int plusIndex;
            String modifierString = this.effect.getModifier().getString();
            int minusIndex = modifierString.indexOf(45);
            int index = Math.max(minusIndex, plusIndex = modifierString.indexOf(43));
            if (index == -1) {
                return StyledText.fromString(String.valueOf(ChatFormatting.GRAY) + this.count + "x").append(this.effect.getModifier());
            }
            return StyledText.fromString(String.valueOf(ChatFormatting.GRAY) + modifierString.substring(0, ++index) + this.count + "x" + modifierString.substring(index));
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int c) {
            this.count = c;
        }

        public StatusEffect getEffect() {
            return this.effect;
        }

        public void addModifier(double modifier) {
            this.modifierList.add(modifier);
        }
    }
}

