/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays.objectives;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.scoreboard.event.ScoreboardSegmentAdditionEvent;
import com.wynntils.models.objectives.GuildObjectiveScoreboardPart;
import com.wynntils.models.objectives.WynnObjective;
import com.wynntils.overlays.objectives.ObjectiveOverlayBase;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.ObjectivesTextures;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public class GuildObjectiveOverlay
extends ObjectiveOverlayBase {
    @Persisted
    private final Config<Boolean> disableObjectiveTrackingOnScoreboard = new Config<Boolean>(true);
    @Persisted(i18nKey="feature.wynntils.objectivesOverlay.overlay.objectiveOverlayBase.textColor")
    private final Config<CustomColor> textColor = new Config<CustomColor>(CommonColors.LIGHT_BLUE);

    public GuildObjectiveOverlay() {
        super(new OverlayPosition(-5.5f, -5.0f, VerticalAlignment.BOTTOM, HorizontalAlignment.RIGHT, OverlayPosition.AnchorSection.BOTTOM_RIGHT), new OverlaySize(150.0f, 30.0f), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onScoreboardSegmentChange(ScoreboardSegmentAdditionEvent event) {
        if (((Boolean)this.disableObjectiveTrackingOnScoreboard.get()).booleanValue() && event.getSegment().getScoreboardPart() instanceof GuildObjectiveScoreboardPart) {
            event.setCanceled(true);
            return;
        }
    }

    @Override
    protected boolean isVisible() {
        return Models.Objectives.getGuildObjective() != null;
    }

    @Override
    public void render(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        WynnObjective guildObjective = Models.Objectives.getGuildObjective();
        if (guildObjective == null) {
            return;
        }
        this.renderObjective(guiGraphics, bufferSource, guildObjective);
    }

    @Override
    public void renderPreview(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        WynnObjective guildObjective = Models.Objectives.getGuildObjective();
        if (guildObjective == null) {
            guildObjective = WynnObjective.DEMO_GUILD;
        }
        this.renderObjective(guiGraphics, bufferSource, guildObjective);
    }

    private void renderObjective(GuiGraphics guiGraphics, MultiBufferSource bufferSource, WynnObjective guildObjective) {
        PoseStack poseStack = guiGraphics.pose();
        if (((Boolean)this.hideOnInactivity.get()).booleanValue()) {
            int maxInactivityMs = 3000;
            if (guildObjective.getUpdatedAt() + 3000L < System.currentTimeMillis()) {
                return;
            }
        }
        int barHeight = (Boolean)this.enableProgressBar.get() != false ? 5 : 0;
        int barWidth = 182;
        float actualBarHeight = (float)barHeight * (this.getWidth() / 182.0f);
        float renderedHeight = FontRenderer.getInstance().calculateRenderHeight(guildObjective.asObjectiveString(), this.getWidth()) + actualBarHeight;
        float f = this.getRenderY();
        float renderY = f + (switch (this.getRenderVerticalAlignment()) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> 0.0f;
            case VerticalAlignment.MIDDLE -> (this.getHeight() - renderedHeight) / 2.0f;
            case VerticalAlignment.BOTTOM -> this.getHeight() - renderedHeight;
        });
        String text = guildObjective.asObjectiveString();
        BufferedFontRenderer.getInstance().renderAlignedTextInBox(poseStack, bufferSource, StyledText.fromString(text), this.getRenderX(), this.getRenderX() + this.getWidth(), renderY, this.getWidth(), (CustomColor)this.textColor.get(), this.getRenderHorizontalAlignment(), (TextShadow)this.textShadow.get());
        float height = FontRenderer.getInstance().calculateRenderHeight(text, this.getWidth());
        if (height > 9.0f) {
            renderY += height - 9.0f;
        }
        if (((Boolean)this.enableProgressBar.get()).booleanValue()) {
            BufferedRenderUtils.drawProgressBar(poseStack, bufferSource, Texture.BUBBLE_BAR, this.getRenderX(), renderY + 10.0f, this.getRenderX() + this.getWidth(), renderY + 10.0f + actualBarHeight, 0, ((ObjectivesTextures)this.objectivesTexture.get()).getTextureY1(), 182, ((ObjectivesTextures)this.objectivesTexture.get()).getTextureY2(), guildObjective.getProgress());
        }
    }
}

