/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.colorpicker.widgets;

import com.wynntils.screens.colorpicker.ColorPickerScreen;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.RenderUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class HueSlider
extends AbstractSliderButton {
    private final ColorPickerScreen colorPickerScreen;

    public HueSlider(int x, int y, int width, int height, double value, ColorPickerScreen colorPickerScreen) {
        super(x, y, width, height, (Component)Component.literal((String)""), value);
        this.colorPickerScreen = colorPickerScreen;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (int i = 0; i < this.width; ++i) {
            float hue = (float)i / (float)this.width;
            RenderUtils.drawRect(guiGraphics.pose(), CustomColor.fromHSV(hue, 1.0f, 1.0f, 1.0f), this.getX() + i, this.getY(), 1.0f, 1.0f, this.height);
        }
        double exactX = (double)this.getX() + (double)this.width * this.value;
        int handleX = (int)Math.round(exactX);
        RenderUtils.drawRectBorders(guiGraphics.pose(), CommonColors.DARK_GRAY, (float)((double)handleX - 1.0), this.getY(), (float)((double)handleX + 1.0), this.getY() + this.getHeight(), 2.0f, 1.0f);
    }

    public void onClick(double mouseX, double mouseY) {
        this.updateValue(mouseX);
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        this.updateValue(mouseX);
    }

    protected void updateMessage() {
    }

    protected void applyValue() {
    }

    private void updateValue(double mouseX) {
        float newHue = (float)(mouseX - (double)this.getX()) / (float)this.getWidth();
        this.colorPickerScreen.setHue(Mth.clamp((float)newHue, (float)0.0f, (float)1.0f));
        this.setValue((mouseX - ((double)this.getX() + 0.5)) / (double)(this.width - 1));
    }
}

