/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.WynntilsListScreen;
import com.wynntils.screens.base.widgets.BackButton;
import com.wynntils.screens.base.widgets.PageSelectorButton;
import com.wynntils.screens.guides.aspect.WynntilsAspectGuideScreen;
import com.wynntils.screens.guides.charm.WynntilsCharmGuideScreen;
import com.wynntils.screens.guides.emeraldpouch.WynntilsEmeraldPouchGuideScreen;
import com.wynntils.screens.guides.gear.WynntilsItemGuideScreen;
import com.wynntils.screens.guides.ingredient.WynntilsIngredientGuideScreen;
import com.wynntils.screens.guides.powder.WynntilsPowderGuideScreen;
import com.wynntils.screens.guides.tome.WynntilsTomeGuideScreen;
import com.wynntils.screens.guides.widgets.ExportButton;
import com.wynntils.screens.guides.widgets.GuidesButton;
import com.wynntils.screens.guides.widgets.ImportButton;
import com.wynntils.screens.wynntilsmenu.WynntilsMenuScreen;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.Texture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public final class WynntilsGuidesListScreen
extends WynntilsListScreen<Screen, GuidesButton> {
    private static final List<Screen> GUIDES = List.of(WynntilsItemGuideScreen.create(), WynntilsIngredientGuideScreen.create(), WynntilsTomeGuideScreen.create(), WynntilsCharmGuideScreen.create(), WynntilsAspectGuideScreen.create(), WynntilsEmeraldPouchGuideScreen.create(), WynntilsPowderGuideScreen.create());

    private WynntilsGuidesListScreen() {
        super((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.name"));
    }

    public static Screen create() {
        return new WynntilsGuidesListScreen();
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.addRenderableWidget((GuiEventListener)new BackButton((int)(((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 16.0f) / 2.0f) + this.offsetX, 65 + this.offsetY, Texture.BACK_ARROW_OFFSET.width() / 2, Texture.BACK_ARROW_OFFSET.height(), WynntilsMenuScreen.create()));
        this.addRenderableWidget((GuiEventListener)new ImportButton(Texture.CONTENT_BOOK_BACKGROUND.width() - 21 + this.offsetX, 11 + this.offsetY, (int)((float)Texture.ADD_ICON.width() / 1.5f), (int)((float)Texture.ADD_ICON.height() / 1.5f), this::importFavorites));
        this.addRenderableWidget((GuiEventListener)new ExportButton(Texture.CONTENT_BOOK_BACKGROUND.width() - 21 + this.offsetX, 11 + (int)((float)Texture.ADD_ICON.height() / 1.5f) + this.offsetY, (int)((float)Texture.SHARE_ICON.width() / 1.5f), (int)((float)Texture.SHARE_ICON.height() / 1.5f), this::exportFavorites));
        this.addRenderableWidget((GuiEventListener)new PageSelectorButton((int)((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 50.0f - (float)Texture.FORWARD_ARROW_OFFSET.width() / 2.0f + (float)this.offsetX), Texture.CONTENT_BOOK_BACKGROUND.height() - 25 + this.offsetY, Texture.FORWARD_ARROW_OFFSET.width() / 2, Texture.FORWARD_ARROW_OFFSET.height(), false, this));
        this.addRenderableWidget((GuiEventListener)new PageSelectorButton(Texture.CONTENT_BOOK_BACKGROUND.width() - 50 + this.offsetX, Texture.CONTENT_BOOK_BACKGROUND.height() - 25 + this.offsetY, Texture.FORWARD_ARROW_OFFSET.width() / 2, Texture.FORWARD_ARROW_OFFSET.height(), true, this));
    }

    private void importFavorites() {
        String clipboard = McUtils.mc().keyboardHandler.getClipboard();
        if (clipboard == null || !clipboard.startsWith("wynntilsFavorites,")) {
            McUtils.sendErrorToClient(I18n.get((String)"screens.wynntils.wynntilsGuides.invalidClipboard", (Object[])new Object[0]));
        }
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(clipboard.split(",")));
        names.removeFirst();
        names.forEach(name -> {
            if (name.isBlank()) {
                return;
            }
            Services.Favorites.addFavorite((String)name);
        });
        McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.importedFavorites", (Object[])new Object[]{names.size()}).withStyle(ChatFormatting.GREEN));
    }

    private void exportFavorites() {
        McUtils.mc().keyboardHandler.setClipboard("wynntilsFavorites," + String.join((CharSequence)",", Services.Favorites.getFavoriteItems()));
        McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.exportedFavorites", (Object[])new Object[]{Services.Favorites.getFavoriteItems().size()}).withStyle(ChatFormatting.GREEN));
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        this.renderBackgroundTexture(poseStack);
        this.renderTitle(poseStack, I18n.get((String)"screens.wynntils.wynntilsGuides.name", (Object[])new Object[0]));
        this.renderVersion(poseStack);
        this.renderWidgets(guiGraphics, mouseX, mouseY, partialTick);
        this.renderDescription(poseStack, I18n.get((String)"screens.wynntils.wynntilsGuides.screenDescription", (Object[])new Object[0]), "");
        this.renderPageInfo(poseStack, this.currentPage + 1, this.maxPage + 1);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected GuidesButton getButtonFromElement(int i) {
        int offset = i % this.getElementsPerPage();
        return new GuidesButton((int)((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 15.0f + (float)this.offsetX), offset * 13 + 25 + this.offsetY, Texture.CONTENT_BOOK_BACKGROUND.width() / 2 - 37, 9, (Screen)this.elements.get(i), this.offsetX, this.offsetY);
    }

    @Override
    protected void reloadElementsList(String searchTerm) {
        this.elements.addAll(GUIDES.stream().filter(screen -> StringUtils.partialMatch(StyledText.fromComponent(screen.getTitle()).getStringWithoutFormatting(), searchTerm)).toList());
    }
}

