/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.powder;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.WynntilsListScreen;
import com.wynntils.screens.base.widgets.BackButton;
import com.wynntils.screens.base.widgets.PageSelectorButton;
import com.wynntils.screens.guides.WynntilsGuidesListScreen;
import com.wynntils.screens.guides.powder.GuidePowderItemStack;
import com.wynntils.screens.guides.powder.GuidePowderItemStackButton;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public final class WynntilsPowderGuideScreen
extends WynntilsListScreen<GuidePowderItemStack, GuidePowderItemStackButton> {
    private static final int ELEMENTS_COLUMNS = 7;
    private static final int ELEMENT_ROWS = 7;
    private List<GuidePowderItemStack> parsedItemCache;

    private WynntilsPowderGuideScreen() {
        super((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.powder.name"));
    }

    public static Screen create() {
        return new WynntilsPowderGuideScreen();
    }

    @Override
    protected void doInit() {
        if (this.parsedItemCache == null) {
            this.parsedItemCache = Models.Element.getAllPowderTierInfo().stream().map(GuidePowderItemStack::new).toList();
        }
        super.doInit();
        this.addRenderableWidget((GuiEventListener)new BackButton((int)(((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 16.0f) / 2.0f) + this.offsetX, 65 + this.offsetY, Texture.BACK_ARROW_OFFSET.width() / 2, Texture.BACK_ARROW_OFFSET.height(), WynntilsGuidesListScreen.create()));
        this.addRenderableWidget((GuiEventListener)new PageSelectorButton((int)((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 50.0f - (float)Texture.FORWARD_ARROW_OFFSET.width() / 2.0f + (float)this.offsetX), Texture.CONTENT_BOOK_BACKGROUND.height() - 25 + this.offsetY, Texture.FORWARD_ARROW_OFFSET.width() / 2, Texture.FORWARD_ARROW_OFFSET.height(), false, this));
        this.addRenderableWidget((GuiEventListener)new PageSelectorButton(Texture.CONTENT_BOOK_BACKGROUND.width() - 50 + this.offsetX, Texture.CONTENT_BOOK_BACKGROUND.height() - 25 + this.offsetY, Texture.FORWARD_ARROW_OFFSET.width() / 2, Texture.FORWARD_ARROW_OFFSET.height(), true, this));
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        this.renderBackgroundTexture(poseStack);
        this.renderTitle(poseStack, I18n.get((String)"screens.wynntils.wynntilsGuides.powder.name", (Object[])new Object[0]));
        this.renderDescription(poseStack, I18n.get((String)"screens.wynntils.wynntilsGuides.guideDescription", (Object[])new Object[0]), "");
        this.renderVersion(poseStack);
        this.renderItemsHeader(poseStack);
        this.renderWidgets(guiGraphics, mouseX, mouseY, partialTick);
        this.renderPageInfo(poseStack, this.currentPage + 1, this.maxPage + 1);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Renderable renderable = this.hovered;
        if (renderable instanceof GuidePowderItemStackButton) {
            GuidePowderItemStackButton guidePowderItemStack = (GuidePowderItemStackButton)renderable;
            guiGraphics.renderTooltip(FontRenderer.getInstance().getFont(), (ItemStack)guidePowderItemStack.getItemStack(), mouseX, mouseY);
        }
        super.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderItemsHeader(PoseStack poseStack) {
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.wynntilsGuides.itemGuide.available", (Object[])new Object[0])), (float)Texture.CONTENT_BOOK_BACKGROUND.width() * 0.75f + (float)this.offsetX, 30 + this.offsetY, CommonColors.BLACK, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NONE);
    }

    @Override
    protected GuidePowderItemStackButton getButtonFromElement(int i) {
        int xOffset = i % 7 * 20;
        int yOffset = i % this.getElementsPerPage() / 7 * 20;
        return new GuidePowderItemStackButton((int)((float)xOffset + (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 13.0f + (float)this.offsetX), yOffset + 43 + this.offsetY, 18, 18, (GuidePowderItemStack)((Object)this.elements.get(i)), this);
    }

    @Override
    protected void reloadElementsList(String searchTerm) {
        this.elements.addAll(this.parsedItemCache.stream().filter(itemStack -> StringUtils.partialMatch(StyledText.fromComponent(itemStack.getHoverName()).getStringWithoutFormatting(), searchTerm)).toList());
    }

    @Override
    protected int getElementsPerPage() {
        return 49;
    }
}

