/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.widgets.filters;

import com.wynntils.core.components.Services;
import com.wynntils.models.rewards.TomeType;
import com.wynntils.screens.guides.WynntilsGuideScreen;
import com.wynntils.screens.guides.widgets.filters.GuideFilterButton;
import com.wynntils.screens.guides.widgets.filters.GuideFilterWidget;
import com.wynntils.services.itemfilter.filters.StringStatFilter;
import com.wynntils.services.itemfilter.statproviders.TomeTypeStatProvider;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.EnumUtils;
import com.wynntils.utils.render.Texture;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;

public class TomeTypeFilterWidget
extends GuideFilterWidget {
    private final List<TomeTypeButton> tomeTypeButtons = new ArrayList<TomeTypeButton>();
    private TomeTypeStatProvider provider;

    public TomeTypeFilterWidget(int x, int y, WynntilsGuideScreen guideScreen, ItemSearchQuery searchQuery) {
        super(x, y, 136, 16, guideScreen);
        this.tomeTypeButtons.add(new TomeTypeButton(x, y, TomeType.GUILD_TOME, Texture.GUILD_TOME_FILTER_ICON, searchQuery));
        this.tomeTypeButtons.add(new TomeTypeButton(x + 20, y, TomeType.WEAPON_TOME, Texture.WEAPON_TOME_FILTER_ICON, searchQuery));
        this.tomeTypeButtons.add(new TomeTypeButton(x + 40, y, TomeType.ARMOUR_TOME, Texture.ARMOR_TOME_FILTER_ICON, searchQuery));
        this.tomeTypeButtons.add(new TomeTypeButton(x + 60, y, TomeType.MYSTICISM_TOME, Texture.MYSTICISM_TOME_FILTER_ICON, searchQuery));
        this.tomeTypeButtons.add(new TomeTypeButton(x + 80, y, TomeType.MARATHON_TOME, Texture.MARATHON_TOME_FILTER_ICON, searchQuery));
        this.tomeTypeButtons.add(new TomeTypeButton(x + 100, y, TomeType.LOOTRUN_TOME, Texture.LOOTRUN_TOME_FILTER_ICON, searchQuery));
        this.tomeTypeButtons.add(new TomeTypeButton(x + 120, y, TomeType.EXPERTISE_TOME, Texture.EXPERTISE_TOME_FILTER_ICON, searchQuery));
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.tomeTypeButtons.forEach(widget -> widget.render(guiGraphics, mouseX, mouseY, partialTick));
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean clicked = false;
        for (TomeTypeButton tomeTypeButton : this.tomeTypeButtons) {
            if (!tomeTypeButton.isMouseOver(mouseX, mouseY)) continue;
            clicked = tomeTypeButton.mouseClicked(mouseX, mouseY, button);
            break;
        }
        this.guideScreen.updateSearchFromQuickFilters();
        return clicked;
    }

    @Override
    protected List<StatProviderAndFilterPair> getFilters() {
        ArrayList<StatProviderAndFilterPair> filterPairs = new ArrayList<StatProviderAndFilterPair>();
        for (TomeTypeButton tomeTypeButton : this.tomeTypeButtons) {
            StatProviderAndFilterPair filterPair = tomeTypeButton.getFilterPair(this.provider);
            if (filterPair == null) continue;
            filterPairs.add(filterPair);
        }
        return filterPairs;
    }

    @Override
    public void getProvider() {
        this.provider = Services.ItemFilter.getItemStatProviders().stream().filter(statProvider -> statProvider instanceof TomeTypeStatProvider).map(statProvider -> (TomeTypeStatProvider)statProvider).findFirst().orElseThrow(() -> new IllegalStateException("Could not get tome type stat provider"));
    }

    @Override
    public void updateFromQuery(ItemSearchQuery searchQuery) {
        this.tomeTypeButtons.forEach(classTypeButton -> classTypeButton.updateStateFromQuery(searchQuery));
    }

    private static class TomeTypeButton
    extends GuideFilterButton<TomeTypeStatProvider> {
        private final TomeType tomeType;

        protected TomeTypeButton(int x, int y, TomeType tomeType, Texture texture, ItemSearchQuery searchQuery) {
            super(x, y, texture);
            this.tomeType = tomeType;
            this.updateStateFromQuery(searchQuery);
        }

        @Override
        protected void updateStateFromQuery(ItemSearchQuery searchQuery) {
            this.state = searchQuery.filters().values().stream().filter(filterPair -> filterPair.statProvider() instanceof TomeTypeStatProvider).anyMatch(filterPair -> filterPair.statFilter().matches(EnumUtils.toNiceString(this.tomeType).replace(" ", "_")));
        }

        @Override
        protected StatProviderAndFilterPair getFilterPair(TomeTypeStatProvider provider) {
            if (!this.state) {
                return null;
            }
            Optional<StringStatFilter> statFilterOpt = new StringStatFilter.StringStatFilterFactory().create(EnumUtils.toNiceString(this.tomeType).replace(" ", "_"));
            return statFilterOpt.map(stringStatFilter -> new StatProviderAndFilterPair<String>(provider, (StatFilter<String>)stringStatFilter)).orElse(null);
        }

        @Override
        protected String getFilterName() {
            return I18n.get((String)"service.wynntils.itemFilter.stat.tomeType.name", (Object[])new Object[0]) + " " + EnumUtils.toNiceString(this.tomeType);
        }
    }
}

