/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemsharing;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.items.FakeItemStack;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.screens.base.TextboxScreen;
import com.wynntils.screens.base.WynntilsContainerScreen;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.itemsharing.ItemSharingScreen;
import com.wynntils.screens.itemsharing.SavedItemsMenu;
import com.wynntils.screens.itemsharing.widgets.SavedCategoryButton;
import com.wynntils.screens.itemsharing.widgets.SavedItemsButton;
import com.wynntils.services.itemrecord.type.SavedItem;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public final class SavedItemsScreen
extends WynntilsContainerScreen<SavedItemsMenu> {
    private static final int ITEMS_PER_ROW = 7;
    private static final int MAX_ITEMS = 49;
    private static final int SCROLL_AREA_HEIGHT = 129;
    private boolean addingCategory = false;
    private boolean draggingScroll = false;
    private boolean editingCategory = false;
    private int itemScrollOffset = 0;
    private List<Integer> selectedSlots = new ArrayList<Integer>();
    private Map<Integer, SavedItem> encodedItems = new TreeMap<Integer, SavedItem>();
    private String currentCategory = Services.ItemRecord.getDefaultCategory();
    private TextInputBoxWidget categoryInput;
    private List<Pair<String, String>> selectedItems = new ArrayList<Pair<String, String>>();
    private int dragSelectionStartIndex = -1;

    private SavedItemsScreen(SavedItemsMenu abstractContainerMenu) {
        super(abstractContainerMenu, McUtils.inventory(), (Component)Component.literal((String)"Saved Items Screen"));
    }

    public static Screen create() {
        return new SavedItemsScreen(SavedItemsMenu.create());
    }

    @Override
    protected void doInit() {
        super.doInit();
        Services.ItemRecord.cleanupItemRecord();
        this.leftPos = (this.width - Texture.ITEM_RECORD.width()) / 2;
        this.topPos = (this.height - Texture.ITEM_RECORD.height()) / 2;
        this.addRenderableWidget((GuiEventListener)new SavedItemsButton(this.leftPos + 9, this.topPos + 20, b -> {
            if (b == 0) {
                if (!this.addingCategory && !this.editingCategory) {
                    this.addingCategory = true;
                    this.addCategoryInput();
                } else {
                    this.addCategory(KeyboardUtils.isShiftDown());
                    this.addingCategory = false;
                    this.editingCategory = false;
                }
            }
        }, List.of(Component.translatable((String)"screens.wynntils.savedItems.addTooltip1"), Component.translatable((String)"screens.wynntils.savedItems.addTooltip2"), Component.translatable((String)"screens.wynntils.savedItems.addTooltip3"), Component.translatable((String)"screens.wynntils.savedItems.addTooltip4")), Texture.ITEM_RECORD_ADD));
        this.addRenderableWidget((GuiEventListener)new SavedItemsButton(this.leftPos + 9, this.topPos + 31, b -> {
            this.selectedItems = new ArrayList<Pair<String, String>>();
            this.addingCategory = false;
            this.editingCategory = false;
            this.deleteCategory();
        }, List.of(Component.translatable((String)"screens.wynntils.savedItems.deleteTooltip1"), Component.translatable((String)"screens.wynntils.savedItems.deleteTooltip2")), Texture.ITEM_RECORD_DELETE));
        this.addRenderableWidget((GuiEventListener)new SavedItemsButton(this.leftPos + 9, this.topPos + 42, b -> {
            if (b == 0) {
                this.moveSelectedItems();
            } else if (b == 1) {
                this.selectedItems = new ArrayList<Pair<String, String>>();
                this.selectedSlots = new ArrayList<Integer>();
            }
        }, List.of(Component.translatable((String)"screens.wynntils.savedItems.changeCategoryTooltip1"), Component.translatable((String)"screens.wynntils.savedItems.changeCategoryTooltip2"), Component.translatable((String)"screens.wynntils.savedItems.changeCategoryTooltip3")), Texture.ITEM_RECORD_CONFIRM));
        this.addRenderableWidget((GuiEventListener)new SavedItemsButton(this.leftPos + 9, this.topPos + 144, null, List.of(Component.translatable((String)"screens.wynntils.savedItems.help").withStyle(ChatFormatting.UNDERLINE), Component.translatable((String)"screens.wynntils.savedItems.help1"), Component.translatable((String)"screens.wynntils.savedItems.help2"), Component.translatable((String)"screens.wynntils.savedItems.help3"), Component.translatable((String)"screens.wynntils.savedItems.help4"), Component.translatable((String)"screens.wynntils.savedItems.help5")), Texture.ITEM_RECORD_HELP));
        this.addRenderableWidget((GuiEventListener)new SavedCategoryButton(this.leftPos + 21, this.topPos + 9, this, false));
        this.addRenderableWidget((GuiEventListener)new SavedCategoryButton(this.leftPos + 139, this.topPos + 9, this, true));
        if (this.addingCategory) {
            this.addCategoryInput();
        }
        this.populateItems();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        BufferedRenderUtils.drawTexturedRect(guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource, Texture.ITEM_RECORD, this.leftPos, this.topPos);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot == null) {
            return;
        }
        if (slot.getItem() == ItemStack.EMPTY) {
            return;
        }
        if (mouseButton == 1) {
            if (KeyboardUtils.isShiftDown()) {
                this.deleteItem(this.encodedItems.get(slot.index).base64());
            } else {
                Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(slot.getItem());
                if (wynnItemOpt.isPresent()) {
                    McUtils.setScreen(ItemSharingScreen.create(wynnItemOpt.get(), slot.getItem(), true));
                } else {
                    McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.savedItems.unableToShare"));
                }
            }
        } else if (mouseButton == 0) {
            int index;
            int rowOffset = 7 * this.itemScrollOffset;
            this.dragSelectionStartIndex = index = slot.index + rowOffset;
        }
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        PoseStack poseStack = guiGraphics.pose();
        if (!this.addingCategory && !this.editingCategory) {
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(this.currentCategory), this.leftPos + 37, this.leftPos + 37 + 97, this.topPos + 10, this.topPos + 10 + 8, 97.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NONE);
        }
        for (int selectedSlot : this.selectedSlots) {
            BufferedRenderUtils.drawRectBorders(poseStack, (MultiBufferSource)guiGraphics.bufferSource, CommonColors.WHITE, this.leftPos + ((SavedItemsMenu)this.getMenu()).getSlot((int)selectedSlot).x, this.topPos + ((SavedItemsMenu)this.getMenu()).getSlot((int)selectedSlot).y, this.leftPos + ((SavedItemsMenu)this.getMenu()).getSlot((int)selectedSlot).x + 16, this.topPos + ((SavedItemsMenu)this.getMenu()).getSlot((int)selectedSlot).y + 16, 200.0f, 1.0f);
        }
        this.renderScrollButton(poseStack);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        float scrollButtonRenderX = this.leftPos + 155;
        float scrollButtonRenderY = (float)(this.topPos + 18) + MathUtils.map(this.itemScrollOffset, 0.0f, this.getMaxScrollOffset(), 0.0f, 129.0f);
        if (MathUtils.isInside((int)mouseX, (int)mouseY, (int)scrollButtonRenderX, (int)(scrollButtonRenderX + (float)Texture.ITEM_RECORD_SCROLL.width()), (int)scrollButtonRenderY, (int)(scrollButtonRenderY + (float)Texture.ITEM_RECORD_SCROLL.height()))) {
            this.draggingScroll = true;
            return true;
        }
        float categoryRenderX = this.leftPos + 36;
        float categoryRenderY = this.topPos + 10;
        if (!this.currentCategory.equals(Services.ItemRecord.getDefaultCategory()) && !this.editingCategory && !this.addingCategory && MathUtils.isInside((int)mouseX, (int)mouseY, (int)categoryRenderX, (int)(categoryRenderX + 97.0f), (int)categoryRenderY, (int)(categoryRenderY + 8.0f))) {
            this.editingCategory = true;
            this.addCategoryInput();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.draggingScroll) {
            return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        int renderY = this.topPos + 18;
        int newValue = Math.round(MathUtils.map((float)mouseY, renderY, renderY + 129, 0.0f, this.getMaxScrollOffset()));
        this.scrollItems(newValue - this.itemScrollOffset);
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggingScroll = false;
        Slot dragSelectionEndSlot = this.getHoveredSlot(mouseX, mouseY);
        if (this.dragSelectionStartIndex != -1) {
            int dragSelectionEndIndex = dragSelectionEndSlot == null ? this.dragSelectionStartIndex : dragSelectionEndSlot.index;
            int index = Math.min(this.dragSelectionStartIndex, dragSelectionEndIndex);
            int endIndex = Math.max(this.dragSelectionStartIndex, dragSelectionEndIndex);
            for (int i = index; i <= endIndex && i < this.encodedItems.size(); ++i) {
                SavedItem savedItem = this.encodedItems.get(i);
                if (this.selectedItems.contains(new Pair<String, String>(this.currentCategory, savedItem.base64()))) {
                    this.selectedItems.remove(new Pair<String, String>(this.currentCategory, savedItem.base64()));
                    this.selectedSlots.remove((Object)i);
                    continue;
                }
                this.selectedItems.add(new Pair<String, String>(this.currentCategory, savedItem.base64()));
                this.selectedSlots.add(i);
            }
            this.dragSelectionStartIndex = -1;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        double scrollValue = -Math.signum(deltaY);
        if (mouseY < (double)(this.topPos + 18)) {
            this.scrollCategories((int)scrollValue);
        } else {
            this.scrollItems((int)scrollValue);
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if ((this.addingCategory || this.editingCategory) && keyCode == 257) {
            this.addCategory(KeyboardUtils.isShiftDown());
            if (this.addingCategory) {
                this.addingCategory = false;
            } else if (this.editingCategory) {
                this.editingCategory = false;
            }
            return false;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void scrollCategories(int scrollDirection) {
        ArrayList categories = new ArrayList((Collection)Services.ItemRecord.categories.get());
        this.addingCategory = false;
        this.editingCategory = false;
        this.removeWidget((GuiEventListener)this.categoryInput);
        this.categoryInput = null;
        int currentIndex = categories.indexOf(this.currentCategory);
        int newIndex = currentIndex + scrollDirection;
        this.currentCategory = newIndex >= categories.size() ? (String)categories.getFirst() : (newIndex < 0 ? (String)categories.getLast() : (String)categories.get(newIndex));
        this.itemScrollOffset = 0;
        this.populateItems();
    }

    private void renderScrollButton(PoseStack poseStack) {
        float renderX = this.leftPos + 155;
        float renderY = (float)(this.topPos + 18) + MathUtils.map(this.itemScrollOffset, 0.0f, this.getMaxScrollOffset(), 0.0f, 129.0f);
        RenderUtils.drawTexturedRect(poseStack, Texture.ITEM_RECORD_SCROLL, renderX, renderY);
    }

    private void addCategoryInput() {
        if (this.categoryInput != null) {
            this.removeWidget((GuiEventListener)this.categoryInput);
        }
        this.categoryInput = new TextInputBoxWidget(this.leftPos + 37, this.topPos + 5, 97, 16, null, (TextboxScreen)McUtils.screen(), this.categoryInput);
        if (this.editingCategory) {
            this.categoryInput.setTextBoxInput(this.currentCategory);
        }
        this.addRenderableWidget((GuiEventListener)this.categoryInput);
    }

    private void addCategory(boolean keepOriginals) {
        String newCategory = this.categoryInput.getTextBoxInput();
        this.removeWidget((GuiEventListener)this.categoryInput);
        this.categoryInput = null;
        if (newCategory.isEmpty()) {
            return;
        }
        if (this.addingCategory) {
            Services.ItemRecord.addCategory(newCategory, this.selectedItems, keepOriginals);
            if (!this.selectedItems.isEmpty()) {
                this.currentCategory = newCategory;
                this.selectedItems = new ArrayList<Pair<String, String>>();
                this.populateItems();
            }
        } else if (this.editingCategory && !this.currentCategory.equals(newCategory)) {
            Services.ItemRecord.renameCategory(this.currentCategory, newCategory);
            this.currentCategory = newCategory;
            this.populateItems();
        }
    }

    private void deleteCategory() {
        Services.ItemRecord.deleteCategory(this.currentCategory);
        if (this.categoryInput != null) {
            this.removeWidget((GuiEventListener)this.categoryInput);
            this.categoryInput = null;
        }
        this.currentCategory = Services.ItemRecord.getDefaultCategory();
        this.populateItems();
    }

    private void moveSelectedItems() {
        Services.ItemRecord.moveSelectedItems(this.selectedItems, this.currentCategory, KeyboardUtils.isShiftDown());
        this.selectedItems = new ArrayList<Pair<String, String>>();
        this.populateItems();
    }

    private void deleteItem(String base64) {
        Services.ItemRecord.deleteItem(base64);
        if ((((SavedItemsMenu)this.menu).getItems().size() - 1) % 7 == 0 && this.itemScrollOffset > 0) {
            --this.itemScrollOffset;
        }
        this.populateItems();
    }

    private void populateItems() {
        int rowOffset;
        int i;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList<ItemStack> selected = new ArrayList<ItemStack>();
        this.encodedItems = new TreeMap<Integer, SavedItem>();
        this.selectedSlots = new ArrayList<Integer>();
        ((SavedItemsMenu)this.menu).clear();
        List<SavedItem> savedItems = ((Set)Services.ItemRecord.savedItems.get()).stream().filter(savedItem -> savedItem.categories().contains(this.currentCategory)).toList();
        if (savedItems.isEmpty()) {
            return;
        }
        this.encodedItems = savedItems.stream().collect(TreeMap::new, (map, savedItem) -> map.put(map.size(), savedItem), TreeMap::putAll);
        for (i = rowOffset = 7 * this.itemScrollOffset; i < 49 + rowOffset && i < savedItems.size(); ++i) {
            ItemStack itemStack;
            SavedItem savedItem2 = savedItems.get(i);
            WynnItem wynnItem = savedItem2.wynnItem();
            if (wynnItem instanceof GearItem) {
                GearItem gearItem = (GearItem)wynnItem;
                itemStack = gearItem.getItemInfo().metaInfo().material().itemStack();
            } else {
                itemStack = savedItem2.itemStack();
            }
            itemStack = new FakeItemStack(savedItem2.wynnItem(), itemStack, "From " + McUtils.playerName() + "'s Item Record");
            for (Pair<String, String> selectedItem : this.selectedItems) {
                if (!selectedItem.a().equals(this.currentCategory) || !selectedItem.b().equals(savedItem2.base64())) continue;
                selected.add(itemStack);
                break;
            }
            items.add(itemStack);
        }
        for (i = 0; i < 49 && i <= items.size() - 1; ++i) {
            ((SavedItemsMenu)this.menu).setItem(i, 0, (ItemStack)items.get(i));
            if (!selected.contains(items.get(i))) continue;
            this.selectedSlots.add(i);
        }
    }

    private void scrollItems(int scollDirection) {
        int maxValue = this.getMaxScrollOffset();
        this.itemScrollOffset = MathUtils.clamp(this.itemScrollOffset + scollDirection, 0, maxValue);
        this.populateItems();
    }

    private int getMaxScrollOffset() {
        int maxItemOffset = Math.max(0, ((Set)Services.ItemRecord.savedItems.get()).stream().filter(savedItem -> savedItem.categories().contains(this.currentCategory)).toList().size() - 49);
        return maxItemOffset / 7 + (maxItemOffset % 7 > 0 ? 1 : 0);
    }
}

