/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemsharing.widgets;

import com.google.common.collect.Lists;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;

public class SavedItemsButton
extends WynntilsButton {
    private final Consumer<Integer> onClick;
    private final List<Component> tooltip;
    private final Texture buttonTexture;

    public SavedItemsButton(int x, int y, Consumer<Integer> onClick, List<Component> tooltip, Texture buttonTexture) {
        super(x, y, 9, 9, (Component)Component.literal((String)"Saved Items Button"));
        this.onClick = onClick;
        this.tooltip = ComponentUtils.wrapTooltips(tooltip, 200);
        this.buttonTexture = buttonTexture;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        BufferedRenderUtils.drawHoverableTexturedRect(guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource, this.buttonTexture, this.getX(), this.getY(), this.isHovered);
        if (this.isHovered) {
            McUtils.screen().setTooltipForNextRenderPass(Lists.transform(this.tooltip, Component::getVisualOrderText));
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (this.onClick != null) {
            this.onClick.accept(button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void onPress() {
    }
}

