/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.partymanagement.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.partymanagement.widgets.AbstractPlayerListEntryWidget;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class PartyMemberWidget
extends AbstractPlayerListEntryWidget {
    private final Button promoteButton;
    private final Button kickButton;
    private final Button disbandButton;
    private final Button moveUpButton;
    private final Button moveDownButton;

    public PartyMemberWidget(float x, float y, int width, int height, String playerName, boolean isOffline, float gridDivisions) {
        super((int)x, (int)y, width, height, playerName, isOffline, gridDivisions);
        int baseButtonWidth = (int)((float)this.width / gridDivisions);
        this.promoteButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.partyManagementGui.promote"), button -> Models.Party.partyPromote(playerName)).pos((int)((float)this.getX() + (float)this.width / this.gridDivisions * 16.0f) + 1, this.getY()).size(baseButtonWidth * 4, height).build();
        this.kickButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.partyManagementGui.kick"), button -> Models.Party.partyKick(playerName)).pos((int)((float)this.getX() + (float)this.width / this.gridDivisions * 20.0f) + 1, this.getY()).size(baseButtonWidth * 4, height).build();
        this.disbandButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.partyManagementGui.disband"), button -> Models.Party.partyDisband()).pos((int)((float)this.getX() + (float)this.width / this.gridDivisions * 20.0f) + 1, this.getY()).size(baseButtonWidth * 4, height).build();
        this.moveUpButton = new Button.Builder((Component)Component.literal((String)"\ud83e\udc1d"), button -> Models.Party.increasePlayerPriority(playerName)).pos((int)((float)this.getX() + (float)this.width / this.gridDivisions * 24.0f) + 1, this.getY()).size(baseButtonWidth * 2, height).build();
        this.moveDownButton = new Button.Builder((Component)Component.literal((String)"\ud83e\udc1f"), button -> Models.Party.decreasePlayerPriority(playerName)).pos((int)((float)this.getX() + (float)this.width / this.gridDivisions * 26.0f) + 1, this.getY()).size(baseButtonWidth * 2, height).build();
        if (Models.Party.isPartyLeader(playerName)) {
            this.promoteButton.active = false;
            this.kickButton.active = false;
        } else {
            this.disbandButton.active = false;
        }
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        PoseStack poseStack = guiGraphics.pose();
        CustomColor color = CommonColors.WHITE;
        if (Models.Party.isPartyLeader(this.playerName)) {
            color = CommonColors.YELLOW;
        } else if (Models.Friends.getFriends().contains(this.playerName)) {
            color = CommonColors.GREEN;
        }
        String prefix = "";
        if (this.isOffline) {
            prefix = ChatFormatting.STRIKETHROUGH.toString();
        } else if (this.playerName.equals(McUtils.playerName())) {
            prefix = ChatFormatting.BOLD.toString();
        }
        StyledText formattedPlayerName = StyledText.fromString(prefix + this.playerName);
        FontRenderer.getInstance().renderText(poseStack, formattedPlayerName, (float)this.getX() + (float)this.width / this.gridDivisions * 3.0f, this.getY() + this.height / 2, color, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        this.moveUpButton.render(guiGraphics, mouseX, mouseY, partialTick);
        this.moveDownButton.render(guiGraphics, mouseX, mouseY, partialTick);
        if (!Models.Party.isPartyLeader(McUtils.playerName())) {
            return;
        }
        if (Models.Party.isPartyLeader(this.playerName)) {
            this.disbandButton.render(guiGraphics, mouseX, mouseY, partialTick);
        } else {
            this.promoteButton.render(guiGraphics, mouseX, mouseY, partialTick);
            this.kickButton.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.moveUpButton.mouseClicked(mouseX, mouseY, button) || this.moveDownButton.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (!Models.Party.isPartyLeader(McUtils.playerName())) {
            return false;
        }
        return this.promoteButton.mouseClicked(mouseX, mouseY, button) || this.kickButton.mouseClicked(mouseX, mouseY, button) || this.disbandButton.mouseClicked(mouseX, mouseY, button);
    }
}

