/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.settings;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Configurable;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.overlays.CustomNameProperty;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.persisted.Translatable;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.widgets.SearchWidget;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.settings.widgets.CategoryButton;
import com.wynntils.screens.settings.widgets.ConfigTile;
import com.wynntils.screens.settings.widgets.ConfigurableButton;
import com.wynntils.screens.settings.widgets.SettingsCategoryTabButton;
import com.wynntils.screens.settings.widgets.SettingsPageTabButton;
import com.wynntils.screens.settings.widgets.SettingsSearchWidget;
import com.wynntils.screens.settings.widgets.SettingsSideTabButton;
import com.wynntils.screens.settings.widgets.UnsavedChangesWidget;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public final class WynntilsBookSettingsScreen
extends WynntilsScreen {
    private static final float SCROLL_FACTOR = 10.0f;
    private static final int MASK_TOP_Y = 21;
    private static final int CONFIG_MASK_BOTTOM_Y = 205;
    private static final int CONFIGURABLE_MASK_BOTTOM_Y = 211;
    private static final int CONFIGURABLES_PER_PAGE = 16;
    private static final int CONFIGS_PER_PAGE = 4;
    private static final int CONFIGURABLE_SCROLL_X = (int)((float)Texture.CONFIG_BOOK_BACKGROUND.width() / 2.0f - 12.0f);
    private static final int CONFIG_SCROLL_X = Texture.CONFIG_BOOK_BACKGROUND.width() - 23;
    private static final int MAX_DISPLAYED_CATEGORIES = 10;
    private static final int SCROLL_AREA_HEIGHT = 186;
    private static final int SCROLL_START_Y = 21;
    private final List<Category> sortedCategories;
    private final List<WynntilsButton> configurables = new ArrayList<WynntilsButton>();
    private final List<WynntilsButton> configs = new ArrayList<WynntilsButton>();
    private List<Configurable> configurableList;
    private Map<Configurable, List<ConfigTile>> configurableMap = new HashMap<Configurable, List<ConfigTile>>();
    private List<SettingsCategoryTabButton> categoryButtons = new ArrayList<SettingsCategoryTabButton>();
    private final SearchWidget searchWidget;
    private SettingsCategoryTabButton allCategoriesButton;
    private SettingsCategoryTabButton selectedCategoryButton;
    private TextInputBoxWidget focusedTextInput;
    private UnsavedChangesWidget unsavedChangesWidget;
    private boolean draggingConfigurableScroll = false;
    private boolean draggingConfigScroll = false;
    private int categoriesScrollOffset = 0;
    private int configurablesScrollOffset = 0;
    private int configScrollOffset = 0;
    private int offsetX;
    private int offsetY;
    private float configurableScrollRenderY;
    private float configScrollRenderY;
    private boolean unsavedChanges = false;
    private boolean displayWarning = false;
    private Category selectedCategory;
    private Configurable selectedConfigurable = null;
    private Configurable hoveredConfigurable = null;
    private final Screen previousScreen;

    private WynntilsBookSettingsScreen(Screen previousScreen) {
        super((Component)Component.translatable((String)"screens.wynntils.settingsScreen.name"));
        this.previousScreen = previousScreen;
        this.searchWidget = new SettingsSearchWidget(55, Texture.CONFIG_BOOK_BACKGROUND.height() + 6, 120, 20, s -> {
            this.configurablesScrollOffset = 0;
            this.getFilteredConfigurables();
            this.populateConfigurables();
        }, this);
        this.setFocusedTextInput(this.searchWidget);
        this.sortedCategories = Arrays.asList(Category.values());
        this.sortedCategories.sort(Comparator.comparing(Enum::name));
    }

    public static Screen create(Screen previousScreen) {
        return new WynntilsBookSettingsScreen(previousScreen);
    }

    @Override
    protected void doInit() {
        this.offsetX = (int)((float)(this.width - Texture.CONFIG_BOOK_BACKGROUND.width()) / 2.0f);
        this.offsetY = (int)((float)(this.height - Texture.CONFIG_BOOK_BACKGROUND.height()) / 2.0f);
        this.searchWidget.setX(55 + this.offsetX);
        this.searchWidget.setY(Texture.CONFIG_BOOK_BACKGROUND.height() + 6 + this.offsetY);
        this.populateCategories();
        this.getFilteredConfigurables();
        this.populateConfigurables();
        int yPos = Texture.TAG_BLUE.height() / 2 + this.offsetY;
        this.addRenderableWidget((GuiEventListener)new SettingsSideTabButton((int)(-((float)Texture.TAG_BLUE.width() * 0.75f)) + this.offsetX, yPos, Texture.TAG_BLUE.width(), Texture.TAG_BLUE.height(), this::importSettings, ComponentUtils.wrapTooltips(List.of(Component.translatable((String)"screens.wynntils.settingsScreen.import").withStyle(ChatFormatting.YELLOW), Component.translatable((String)"screens.wynntils.settingsScreen.import.all").withStyle(ChatFormatting.GRAY), Component.translatable((String)"screens.wynntils.settingsScreen.import.selected").withStyle(ChatFormatting.GRAY)), 150), Texture.TAG_BLUE, Texture.IMPORT_SETTINGS_ICON, this.offsetX, this.offsetY));
        this.addRenderableWidget((GuiEventListener)new SettingsSideTabButton((int)(-((float)Texture.TAG_BLUE.width() * 0.75f)) + this.offsetX, yPos += 15 + Texture.TAG_BLUE.height() / 2, Texture.TAG_BLUE.width(), Texture.TAG_BLUE.height(), this::exportSettings, ComponentUtils.wrapTooltips(List.of(Component.translatable((String)"screens.wynntils.settingsScreen.export").withStyle(ChatFormatting.BLUE), Component.translatable((String)"screens.wynntils.settingsScreen.export.all").withStyle(ChatFormatting.GRAY), Component.translatable((String)"screens.wynntils.settingsScreen.export.selected").withStyle(ChatFormatting.GRAY)), 150), Texture.TAG_BLUE, Texture.EXPORT_SETTINGS_ICON, this.offsetX, this.offsetY));
        this.addRenderableWidget((GuiEventListener)new SettingsSideTabButton((int)(-((float)Texture.TAG_BLUE.width() * 0.75f)) + this.offsetX, yPos += 15 + Texture.TAG_BLUE.height() / 2, Texture.TAG_BLUE.width(), Texture.TAG_BLUE.height(), b -> {
            Managers.Config.saveConfig();
            this.unsavedChanges = false;
            this.displayWarning = false;
            this.unsavedChangesWidget.visible = false;
            this.onClose();
        }, ComponentUtils.wrapTooltips(List.of(Component.translatable((String)"screens.wynntils.settingsScreen.apply").withStyle(ChatFormatting.GREEN), Component.translatable((String)"screens.wynntils.settingsScreen.apply.description").withStyle(ChatFormatting.GRAY)), 150), Texture.TAG_BLUE, Texture.APPLY_SETTINGS_ICON, this.offsetX, this.offsetY));
        this.addRenderableWidget((GuiEventListener)new SettingsSideTabButton((int)(-((float)Texture.TAG_BLUE.width() * 0.75f)) + this.offsetX, yPos += 15 + Texture.TAG_BLUE.height() / 2, Texture.TAG_BLUE.width(), Texture.TAG_BLUE.height(), b -> {
            this.unsavedChanges = false;
            this.displayWarning = false;
            this.unsavedChangesWidget.visible = false;
            this.onClose();
        }, ComponentUtils.wrapTooltips(List.of(Component.translatable((String)"screens.wynntils.settingsScreen.close").withStyle(ChatFormatting.RED), Component.translatable((String)"screens.wynntils.settingsScreen.close.description").withStyle(ChatFormatting.GRAY)), 150), Texture.TAG_BLUE, Texture.DISCARD_SETTINGS_ICON, this.offsetX, this.offsetY));
        int xPos = (int)((double)Texture.TAG_RED.width() * 0.85) + this.offsetX;
        this.allCategoriesButton = (SettingsCategoryTabButton)this.addRenderableWidget((GuiEventListener)new SettingsCategoryTabButton(xPos, (int)(-((float)Texture.TAG_RED.height() * 0.75f)) + this.offsetY, Texture.TAG_RED.width(), Texture.TAG_RED.height(), b -> this.changeCategory(null), List.of(Component.literal((String)"All")), this.selectedCategory == null, this.offsetX, this.offsetY));
        if (this.selectedCategory == null) {
            this.selectedCategoryButton = this.allCategoriesButton;
        }
        this.addRenderableWidget((GuiEventListener)new SettingsPageTabButton(xPos += Texture.TAG_RED.width() * 2 + 1, (int)(-((float)Texture.TAG_RED.height() * 0.75f)) + this.offsetY, Texture.TAG_RED.width(), Texture.TAG_RED.height(), b -> this.scrollCategorories(-1), List.of(Component.translatable((String)"screens.wynntils.settingsScreen.previous")), false, this.offsetX, this.offsetY));
        this.addRenderableWidget((GuiEventListener)new SettingsPageTabButton(xPos += (int)((double)Texture.TAG_RED.width() * 1.25 * 11.0 - (double)Texture.TAG_RED.width() * 0.25), (int)(-((float)Texture.TAG_RED.height() * 0.75f)) + this.offsetY, Texture.TAG_RED.width(), Texture.TAG_RED.height(), b -> this.scrollCategorories(1), List.of(Component.translatable((String)"screens.wynntils.settingsScreen.next")), true, this.offsetX, this.offsetY));
        this.addRenderableWidget((GuiEventListener)this.searchWidget);
        this.unsavedChangesWidget = new UnsavedChangesWidget((int)((float)(this.width - Texture.SETTINGS_WARNING_BACKGROUND.width()) / 2.0f), (int)((float)(this.height - Texture.SETTINGS_WARNING_BACKGROUND.height()) / 2.0f), this);
        this.unsavedChangesWidget.visible = this.displayWarning;
        this.addRenderableWidget((GuiEventListener)this.unsavedChangesWidget);
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        PoseStack poseStack = guiGraphics.pose();
        if (this.displayWarning) {
            this.unsavedChangesWidget.render(guiGraphics, mouseX, mouseY, partialTick);
            return;
        }
        this.renderTags(guiGraphics, mouseX, mouseY, partialTick);
        this.renderBg(poseStack);
        String categoryName = this.selectedCategory == null ? I18n.get((String)"screens.wynntils.settingsScreen.all", (Object[])new Object[0]) : I18n.get((String)this.selectedCategory.toString(), (Object[])new Object[0]);
        FontRenderer fontRenderer = FontRenderer.getInstance();
        StyledText styledText = StyledText.fromString(categoryName);
        float f = (float)Texture.CONFIG_BOOK_BACKGROUND.width() * 0.25f + (float)this.offsetX;
        Objects.requireNonNull(McUtils.mc().font);
        fontRenderer.renderText(poseStack, styledText, f, 9 + 5 + this.offsetY, CommonColors.LIGHT_GRAY, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        RenderUtils.drawLine(poseStack, CommonColors.GRAY, this.offsetX + 11, this.offsetY + 19, (float)Texture.CONFIG_BOOK_BACKGROUND.width() / 2.0f - 6.0f + (float)this.offsetX, 19 + this.offsetY, 0.0f, 1.0f);
        if (this.selectedConfigurable != null || this.hoveredConfigurable != null) {
            CustomNameProperty customNameProperty;
            Configurable configurable = this.hoveredConfigurable != null ? this.hoveredConfigurable : this.selectedConfigurable;
            String textToRender = configurable.getTranslatedName();
            if (configurable instanceof CustomNameProperty && !((String)(customNameProperty = (CustomNameProperty)((Object)configurable)).getCustomName().get()).isEmpty()) {
                textToRender = (String)customNameProperty.getCustomName().get();
            }
            FontRenderer fontRenderer2 = FontRenderer.getInstance();
            StyledText styledText2 = StyledText.fromString(textToRender);
            float f2 = (float)Texture.CONFIG_BOOK_BACKGROUND.width() * 0.75f + (float)this.offsetX;
            Objects.requireNonNull(McUtils.mc().font);
            fontRenderer2.renderText(poseStack, styledText2, f2, 9 + 5 + this.offsetY, CommonColors.LIGHT_GRAY, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
            RenderUtils.drawLine(poseStack, CommonColors.GRAY, (float)Texture.CONFIG_BOOK_BACKGROUND.width() / 2.0f + 6.0f + (float)this.offsetX, 19 + this.offsetY, Texture.CONFIG_BOOK_BACKGROUND.width() - 11 + this.offsetX, 19 + this.offsetY, 0.0f, 1.0f);
        } else {
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.settingsScreen.unselectedConfig")), (float)Texture.CONFIG_BOOK_BACKGROUND.width() / 2.0f + (float)this.offsetX, (float)(Texture.CONFIG_BOOK_BACKGROUND.width() + this.offsetX), (float)Texture.CONFIG_BOOK_BACKGROUND.height() * 0.25f + (float)this.offsetY, (float)Texture.CONFIG_BOOK_BACKGROUND.height() * 0.75f + (float)this.offsetY, (float)Texture.CONFIG_BOOK_BACKGROUND.width() / 3.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NORMAL, 1.25f);
        }
        if (this.configurables.size() > 16) {
            this.renderConfigurableScroll(poseStack);
        }
        if (this.hoveredConfigurable == null && this.configs.size() > 4) {
            this.renderSelectedConfigScroll(poseStack);
        } else if (this.hoveredConfigurable != null && this.configurableMap.get(this.hoveredConfigurable).size() > 4) {
            this.renderHoveredConfigScroll(poseStack);
        }
        this.renderConfigurables(guiGraphics, mouseX, mouseY, partialTick);
        if (this.hoveredConfigurable == null) {
            this.renderSelectedConfigs(guiGraphics, mouseX, mouseY, partialTick);
        } else {
            this.renderHoveredConfigs(guiGraphics, mouseX, mouseY, partialTick);
        }
        this.renderTooltips(guiGraphics, mouseX, mouseY);
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (McUtils.mc().level == null) {
            this.renderPanorama(guiGraphics, partialTick);
        }
    }

    public void added() {
        this.searchWidget.opened();
        super.added();
    }

    public void onClose() {
        if (this.unsavedChanges) {
            this.displayWarning = true;
            this.unsavedChangesWidget.visible = true;
            return;
        }
        Managers.Config.reloadConfiguration(true);
        if (this.previousScreen != null) {
            McUtils.setScreen(this.previousScreen);
        } else {
            super.onClose();
        }
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (this.displayWarning) {
            if (this.unsavedChangesWidget.isMouseOver(mouseX, mouseY)) {
                return this.unsavedChangesWidget.mouseClicked(mouseX, mouseY, button);
            }
            return false;
        }
        for (GuiEventListener listener : this.getWidgetsForIteration().toList()) {
            if (!listener.isMouseOver(mouseX, mouseY)) continue;
            return listener.mouseClicked(mouseX, mouseY, button);
        }
        if (!this.draggingConfigurableScroll && MathUtils.isInside((int)mouseX, (int)mouseY, CONFIGURABLE_SCROLL_X + this.offsetX, CONFIGURABLE_SCROLL_X + Texture.CONFIG_BOOK_SCROLL_BUTTON.width() + this.offsetX, (int)this.configurableScrollRenderY, (int)(this.configurableScrollRenderY + (float)Texture.CONFIG_BOOK_SCROLL_BUTTON.height() / 2.0f))) {
            this.draggingConfigurableScroll = true;
            return true;
        }
        if (!this.draggingConfigScroll && this.configs.size() > 4 && MathUtils.isInside((int)mouseX, (int)mouseY, CONFIG_SCROLL_X + this.offsetX, CONFIG_SCROLL_X + Texture.CONFIG_BOOK_SCROLL_BUTTON.width() + this.offsetX, (int)this.configScrollRenderY, (int)(this.configScrollRenderY + (float)Texture.CONFIG_BOOK_SCROLL_BUTTON.height() / 2.0f))) {
            this.draggingConfigScroll = true;
            return true;
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.displayWarning) {
            if (this.unsavedChangesWidget.isMouseOver(mouseX, mouseY)) {
                return this.unsavedChangesWidget.mouseDragged(mouseX, mouseY, button, dragX, dragY);
            }
            return false;
        }
        if (this.draggingConfigurableScroll) {
            int scrollAreaStartY = 28 + this.offsetY;
            int newOffset = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, (float)(scrollAreaStartY + 186) - (float)Texture.CONFIG_BOOK_SCROLL_BUTTON.height() / 2.0f, 0.0f, this.getMaxConfigurableScrollOffset()));
            newOffset = Math.max(0, Math.min(newOffset, this.getMaxConfigurableScrollOffset()));
            this.scrollConfigurables(newOffset);
            return true;
        }
        if (this.draggingConfigScroll) {
            int scrollAreaStartY = 28 + this.offsetY;
            int newOffset = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, (float)(scrollAreaStartY + 186) - (float)Texture.CONFIG_BOOK_SCROLL_BUTTON.height() / 2.0f, 0.0f, this.getMaxConfigScrollOffset()));
            newOffset = Math.max(0, Math.min(newOffset, this.getMaxConfigScrollOffset()));
            this.scrollConfigs(newOffset);
            return true;
        }
        for (GuiEventListener listener : this.getWidgetsForIteration().toList()) {
            if (!listener.isMouseOver(mouseX, mouseY)) continue;
            return listener.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.displayWarning) {
            if (this.unsavedChangesWidget.isMouseOver(mouseX, mouseY)) {
                return this.unsavedChangesWidget.mouseReleased(mouseX, mouseY, button);
            }
            return false;
        }
        for (GuiEventListener listener : this.getWidgetsForIteration().toList()) {
            listener.mouseReleased(mouseX, mouseY, button);
        }
        this.draggingConfigurableScroll = false;
        this.draggingConfigScroll = false;
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.displayWarning) {
            if (this.unsavedChangesWidget.isMouseOver(mouseX, mouseY)) {
                return this.unsavedChangesWidget.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
            }
            return false;
        }
        int scrollAmount = (int)(-deltaY * 10.0);
        if (mouseY <= (double)this.offsetY) {
            this.scrollCategorories((int)(-Math.signum(deltaY)));
        } else if (mouseX <= (double)((float)Texture.CONFIG_BOOK_BACKGROUND.width() / 2.0f + (float)this.offsetX)) {
            int newOffset = Math.max(0, Math.min(this.configurablesScrollOffset + scrollAmount, this.getMaxConfigurableScrollOffset()));
            this.scrollConfigurables(newOffset);
        } else if (this.configs.size() > 4) {
            int newOffset = Math.max(0, Math.min(this.configScrollOffset + scrollAmount, this.getMaxConfigScrollOffset()));
            this.scrollConfigs(newOffset);
        }
        return true;
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        return this.focusedTextInput != null && this.focusedTextInput.charTyped(codePoint, modifiers);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return this.focusedTextInput != null && this.focusedTextInput.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public TextInputBoxWidget getFocusedTextInput() {
        return this.focusedTextInput;
    }

    @Override
    public void setFocusedTextInput(TextInputBoxWidget focusedTextInput) {
        this.focusedTextInput = focusedTextInput;
    }

    public void populateConfigurables() {
        this.configurables.clear();
        Category oldCategory = this.selectedCategory;
        int renderY = 21 + this.offsetY;
        for (Configurable configurable2 : this.configurableList) {
            Category category;
            if (configurable2 instanceof Feature) {
                Feature feature = (Feature)configurable2;
                category = feature.getCategory();
            } else if (configurable2 instanceof Overlay) {
                Overlay overlay2 = (Overlay)configurable2;
                category = Managers.Overlay.getOverlayParent(overlay2).getCategory();
            } else {
                throw new IllegalStateException("Unknown configurable type: " + String.valueOf(configurable2.getClass()));
            }
            if (category != oldCategory) {
                CategoryButton categoryButton = new CategoryButton(12 + this.offsetX, renderY, 170, 12, category);
                categoryButton.visible = renderY >= 9 && renderY <= 208;
                this.configurables.add(categoryButton);
                oldCategory = category;
                renderY += 12;
            }
            int matchingConfigs = 0;
            for (Config<?> config : configurable2.getVisibleConfigOptions()) {
                if (!this.configOptionContains(config)) continue;
                ++matchingConfigs;
            }
            ConfigurableButton configurableButton = new ConfigurableButton(12 + this.offsetX, renderY, 170, 12, configurable2, this, matchingConfigs);
            configurableButton.visible = renderY >= 9 && renderY <= 208;
            this.configurables.add(configurableButton);
            renderY += 12;
            if (!(configurable2 instanceof Feature)) continue;
            Feature feature = (Feature)configurable2;
            for (Overlay overlay3 : Managers.Overlay.getFeatureOverlays(feature).stream().sorted().toList()) {
                matchingConfigs = 0;
                for (Config<?> config : overlay3.getVisibleConfigOptions()) {
                    if (!this.configOptionContains(config)) continue;
                    ++matchingConfigs;
                }
                ConfigurableButton overlayButton = new ConfigurableButton(12 + this.offsetX, renderY, 170, 12, overlay3, this, matchingConfigs);
                overlayButton.visible = renderY >= 9 && renderY <= 208;
                this.configurables.add(overlayButton);
                renderY += 12;
            }
        }
        if (this.selectedConfigurable != null) {
            Stream<Configurable> configurablesList = Stream.concat(Managers.Feature.getFeatures().stream(), Managers.Feature.getFeatures().stream().map(Managers.Overlay::getFeatureOverlays).flatMap(Collection::stream).map(overlay -> overlay));
            Configurable newSelected = configurablesList.filter(configurable -> configurable.getJsonName().equals(this.selectedConfigurable.getJsonName())).findFirst().orElse(null);
            this.setSelectedConfigurable(newSelected);
        }
        this.scrollConfigurables(this.configurablesScrollOffset);
        this.configurableMap = Stream.concat(Managers.Feature.getFeatures().stream(), Managers.Overlay.getOverlays().stream()).collect(Collectors.toMap(configurable -> configurable, x$0 -> this.buildConfigTiles((Configurable)x$0), (a, b) -> a, LinkedHashMap::new));
    }

    private void populateConfigs() {
        this.configs.clear();
        if (this.selectedConfigurable == null) {
            return;
        }
        this.configs.addAll(this.buildConfigTiles(this.selectedConfigurable));
        this.scrollConfigs(this.configScrollOffset);
    }

    public boolean configOptionContains(Config<?> config) {
        return !this.searchWidget.getTextBoxInput().isEmpty() && StringUtils.containsIgnoreCase(config.getDisplayName(), this.searchWidget.getTextBoxInput());
    }

    public void setSelectedConfigurable(Configurable selectedConfigurable) {
        boolean skipScroll = true;
        if (this.selectedConfigurable != selectedConfigurable) {
            this.configScrollOffset = 0;
            skipScroll = false;
        }
        this.selectedConfigurable = selectedConfigurable;
        this.populateConfigs();
        if (skipScroll) {
            return;
        }
        if (!this.searchWidget.getTextBoxInput().isEmpty() && !this.searchMatches(selectedConfigurable)) {
            this.scrollToMatchingConfig();
        }
    }

    public void changesMade() {
        this.unsavedChanges = true;
    }

    public void handleSaveChoice(boolean save) {
        if (save) {
            Managers.Config.saveConfig();
        }
        this.unsavedChanges = false;
        this.displayWarning = false;
        this.unsavedChangesWidget.visible = false;
        this.onClose();
    }

    public Configurable getSelectedConfigurable() {
        return this.selectedConfigurable;
    }

    public int getMaskTopY() {
        return this.offsetY + 21;
    }

    public int getConfigMaskBottomY() {
        return this.offsetY + 205;
    }

    public int getConfigurableMaskBottomY() {
        return this.offsetY + 211;
    }

    /*
     * WARNING - void declaration
     */
    private void populateCategories() {
        void var2_5;
        for (AbstractWidget abstractWidget : this.categoryButtons) {
            this.removeWidget((GuiEventListener)abstractWidget);
        }
        int xPos = (int)((double)Texture.TAG_RED.width() * 2.85 + 1.0) + this.offsetX;
        this.categoryButtons = new ArrayList<SettingsCategoryTabButton>();
        boolean bl = false;
        while (var2_5 < 10) {
            void categoryIndex = var2_5 + this.categoriesScrollOffset < 0 ? var2_5 + this.categoriesScrollOffset + this.sortedCategories.size() : (var2_5 + this.categoriesScrollOffset > this.sortedCategories.size() - 1 ? var2_5 + this.categoriesScrollOffset - this.sortedCategories.size() : var2_5 + this.categoriesScrollOffset);
            Category category = this.sortedCategories.get((int)categoryIndex);
            this.categoryButtons.add((SettingsCategoryTabButton)this.addRenderableWidget((GuiEventListener)new SettingsCategoryTabButton(xPos += (int)((double)Texture.TAG_RED.width() + (double)Texture.TAG_RED.width() * 0.25), (int)(-((float)Texture.TAG_RED.height() * 0.75f)) + this.offsetY, Texture.TAG_RED.width(), Texture.TAG_RED.height(), b -> this.changeCategory(category), List.of(Component.literal((String)I18n.get((String)category.toString(), (Object[])new Object[0]))), category, this.selectedCategory == category, this.offsetX, this.offsetY)));
            ++var2_5;
        }
    }

    private void getFilteredConfigurables() {
        List filteredConfigurables;
        this.configurableList = new ArrayList<Configurable>();
        if (this.selectedCategory != null) {
            filteredConfigurables = Managers.Feature.getFeatures().stream().filter(feature -> this.searchMatches((Translatable)feature) || feature.getVisibleConfigOptions().stream().anyMatch(this::configOptionContains)).map(feature -> feature).sorted().filter(configurable -> this.isCategoryMatching((Configurable)configurable, this.selectedCategory)).collect(Collectors.toList());
            filteredConfigurables.addAll(Managers.Overlay.getOverlays().stream().filter(overlay -> !filteredConfigurables.contains(Managers.Overlay.getOverlayParent((Overlay)overlay))).filter(overlay -> this.searchMatches((Translatable)overlay) || overlay.getVisibleConfigOptions().stream().anyMatch(this::configOptionContains)).sorted().filter(configurable -> this.isCategoryMatching((Configurable)configurable, this.selectedCategory)).toList());
            if (!this.searchWidget.getTextBoxInput().isEmpty()) {
                filteredConfigurables.addAll(Managers.Feature.getFeatures().stream().filter(feature -> this.searchMatches((Translatable)feature) || feature.getVisibleConfigOptions().stream().anyMatch(this::configOptionContains)).map(feature -> feature).sorted().filter(configurable -> !this.isCategoryMatching((Configurable)configurable, this.selectedCategory)).toList());
                filteredConfigurables.addAll(Managers.Overlay.getOverlays().stream().filter(overlay -> !filteredConfigurables.contains(Managers.Overlay.getOverlayParent((Overlay)overlay))).filter(overlay -> this.searchMatches((Translatable)overlay) || overlay.getVisibleConfigOptions().stream().anyMatch(this::configOptionContains)).sorted().filter(configurable -> !this.isCategoryMatching((Configurable)configurable, this.selectedCategory)).toList());
            }
        } else {
            filteredConfigurables = Managers.Feature.getFeatures().stream().filter(feature -> this.searchMatches((Translatable)feature) || feature.getVisibleConfigOptions().stream().anyMatch(this::configOptionContains)).map(feature -> feature).sorted().collect(Collectors.toList());
            filteredConfigurables.addAll(Managers.Overlay.getOverlays().stream().filter(overlay -> !filteredConfigurables.contains(Managers.Overlay.getOverlayParent((Overlay)overlay))).filter(overlay -> this.searchMatches((Translatable)overlay) || overlay.getVisibleConfigOptions().stream().anyMatch(this::configOptionContains)).sorted().toList());
        }
        this.configurableList.addAll(filteredConfigurables);
    }

    private List<ConfigTile> buildConfigTiles(Configurable configurable) {
        List<Config> configOptions = configurable.getVisibleConfigOptions().stream().sorted(Comparator.comparing(config -> !Objects.equals(config.getFieldName(), "userEnabled"))).toList();
        ArrayList<ConfigTile> configTiles = new ArrayList<ConfigTile>();
        int renderY = 21 + this.offsetY;
        for (Config config2 : configOptions) {
            Overlay overlayInstance;
            Overlay overlay = configurable instanceof Overlay ? (overlayInstance = (Overlay)configurable) : null;
            ConfigTile configTile = new ConfigTile(Texture.CONFIG_BOOK_BACKGROUND.width() / 2 + 10 + this.offsetX, renderY, 160, 45, this, config2, overlay);
            configTile.visible = renderY >= 21 + this.offsetY - 46 && renderY <= 21 + this.offsetY + 180;
            configTiles.add(configTile);
            renderY += 46;
        }
        return configTiles;
    }

    private Stream<GuiEventListener> getWidgetsForIteration() {
        return Stream.concat(this.children().stream(), Stream.concat(this.configurables.stream(), this.configs.stream()));
    }

    private void scrollConfigurables(int newOffset) {
        this.configurablesScrollOffset = newOffset;
        for (WynntilsButton configurable : this.configurables) {
            int newY = 21 + this.offsetY + this.configurables.indexOf((Object)configurable) * 12 - this.configurablesScrollOffset;
            configurable.setY(newY);
            configurable.visible = newY >= 21 + this.offsetY - 12 && newY <= 21 + this.offsetY + 187;
        }
    }

    private int getMaxConfigurableScrollOffset() {
        return (this.configurables.size() - 16) * 12;
    }

    private void scrollConfigs(int newOffset) {
        this.configScrollOffset = newOffset;
        for (WynntilsButton config : this.configs) {
            int newY = 21 + this.offsetY + this.configs.indexOf((Object)config) * 46 - this.configScrollOffset;
            config.setY(newY);
            config.visible = newY >= 21 + this.offsetY - 46 && newY <= 21 + this.offsetY + 180;
        }
    }

    private int getMaxConfigScrollOffset() {
        return (this.configs.size() - 4) * 46;
    }

    private void scrollCategorories(int direction) {
        this.categoriesScrollOffset = Math.abs(this.categoriesScrollOffset + direction) == this.sortedCategories.size() ? 0 : MathUtils.clamp(this.categoriesScrollOffset + direction, -(this.sortedCategories.size() - 1), this.sortedCategories.size() - 1);
        this.populateCategories();
    }

    private boolean isCategoryMatching(Configurable configurable, Category selectedCategory) {
        return this.getCategory(configurable) == selectedCategory;
    }

    private void scrollToMatchingConfig() {
        List<Config> configsOptions = this.selectedConfigurable.getVisibleConfigOptions().stream().sorted(Comparator.comparing(config -> !Objects.equals(config.getFieldName(), "userEnabled"))).toList();
        for (Config config2 : configsOptions) {
            if (!StringUtils.containsIgnoreCase(config2.getDisplayName(), this.searchWidget.getTextBoxInput())) continue;
            int newOffset = Math.max(0, Math.min((configsOptions.indexOf(config2) - 3) * 46, this.getMaxConfigScrollOffset()));
            this.scrollConfigs(newOffset);
            return;
        }
    }

    private void changeCategory(Category category) {
        this.configurablesScrollOffset = 0;
        if (this.selectedCategoryButton != null) {
            this.selectedCategoryButton.setSelectedCategory(false);
        }
        this.selectedCategory = category;
        if (category == null) {
            this.selectedCategoryButton = this.allCategoriesButton;
            this.allCategoriesButton.setSelectedCategory(true);
        } else {
            for (SettingsCategoryTabButton settingsTabButton : this.categoryButtons) {
                if (settingsTabButton.getCategory() != this.selectedCategory) continue;
                this.selectedCategoryButton = settingsTabButton;
                settingsTabButton.setSelectedCategory(true);
                break;
            }
        }
        this.getFilteredConfigurables();
        this.populateConfigurables();
        this.populateCategories();
    }

    private Category getCategory(Configurable configurable) {
        if (configurable instanceof Feature) {
            Feature feature = (Feature)configurable;
            return feature.getCategory();
        }
        if (configurable instanceof Overlay) {
            Overlay overlay = (Overlay)configurable;
            return Managers.Overlay.getOverlayParent(overlay).getCategory();
        }
        throw new IllegalStateException("Unknown configurable type: " + String.valueOf(configurable.getClass()));
    }

    private boolean searchMatches(Translatable translatable) {
        CustomNameProperty customNameProperty;
        if (translatable instanceof CustomNameProperty && StringUtils.partialMatch((String)(customNameProperty = (CustomNameProperty)((Object)translatable)).getCustomName().get(), this.searchWidget.getTextBoxInput())) {
            return true;
        }
        return StringUtils.partialMatch(translatable.getTranslatedName(), this.searchWidget.getTextBoxInput());
    }

    private void renderBg(PoseStack poseStack) {
        RenderUtils.drawTexturedRect(poseStack, Texture.CONFIG_BOOK_BACKGROUND, this.offsetX, this.offsetY);
    }

    private void renderTags(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    private void renderConfigurables(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.enableScissor(guiGraphics, 12 + this.offsetX, 21 + this.offsetY, 170, 189);
        this.hoveredConfigurable = null;
        for (WynntilsButton configurable : this.configurables) {
            configurable.render(guiGraphics, mouseX, mouseY, partialTick);
            if (!configurable.isHovered() || !(configurable instanceof ConfigurableButton)) continue;
            ConfigurableButton configurableButton = (ConfigurableButton)configurable;
            Configurable hovered = configurableButton.getConfigurable();
            if (this.selectedConfigurable != null) continue;
            this.hoveredConfigurable = configurableButton.getConfigurable();
        }
        RenderUtils.disableScissor(guiGraphics);
    }

    private void renderConfigurableScroll(PoseStack poseStack) {
        RenderUtils.drawRect(poseStack, CommonColors.GRAY, CONFIGURABLE_SCROLL_X + this.offsetX, 21 + this.offsetY, 0.0f, Texture.CONFIG_BOOK_SCROLL_BUTTON.width(), 186.0f);
        this.configurableScrollRenderY = (float)(21 + this.offsetY) + MathUtils.map(this.configurablesScrollOffset, 0.0f, this.getMaxConfigurableScrollOffset(), 0.0f, 186.0f - (float)Texture.CONFIG_BOOK_SCROLL_BUTTON.height() / 2.0f);
        RenderUtils.drawHoverableTexturedRect(poseStack, Texture.CONFIG_BOOK_SCROLL_BUTTON, CONFIGURABLE_SCROLL_X + this.offsetX, this.configurableScrollRenderY, this.draggingConfigurableScroll);
    }

    private void renderSelectedConfigs(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.enableScissor(guiGraphics, (int)((float)Texture.CONFIG_BOOK_BACKGROUND.width() / 2.0f + 10.0f + (float)this.offsetX), 21 + this.offsetY, 160, 184);
        for (WynntilsButton config : this.configs) {
            config.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        RenderUtils.disableScissor(guiGraphics);
    }

    private void renderHoveredConfigs(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.enableScissor(guiGraphics, (int)((float)Texture.CONFIG_BOOK_BACKGROUND.width() / 2.0f + 10.0f + (float)this.offsetX), 21 + this.offsetY, 160, 184);
        for (WynntilsButton wynntilsButton : this.configurableMap.get(this.hoveredConfigurable)) {
            wynntilsButton.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        RenderUtils.disableScissor(guiGraphics);
    }

    private void renderSelectedConfigScroll(PoseStack poseStack) {
        if (this.configs.size() <= 4) {
            return;
        }
        RenderUtils.drawRect(poseStack, CommonColors.GRAY, CONFIG_SCROLL_X + this.offsetX, 21 + this.offsetY, 0.0f, Texture.CONFIG_BOOK_SCROLL_BUTTON.width(), 186.0f);
        this.configScrollRenderY = (float)(21 + this.offsetY) + MathUtils.map(this.configScrollOffset, 0.0f, this.getMaxConfigScrollOffset(), 0.0f, 186.0f - (float)Texture.CONFIG_BOOK_SCROLL_BUTTON.height() / 2.0f);
        RenderUtils.drawHoverableTexturedRect(poseStack, Texture.CONFIG_BOOK_SCROLL_BUTTON, CONFIG_SCROLL_X + this.offsetX, this.configScrollRenderY, this.draggingConfigScroll);
    }

    private void renderHoveredConfigScroll(PoseStack poseStack) {
        if (this.configurableMap.get(this.hoveredConfigurable).size() <= 4) {
            return;
        }
        RenderUtils.drawRect(poseStack, CommonColors.GRAY, CONFIG_SCROLL_X + this.offsetX, 21 + this.offsetY, 0.0f, Texture.CONFIG_BOOK_SCROLL_BUTTON.width(), 186.0f);
        RenderUtils.drawHoverableTexturedRect(poseStack, Texture.CONFIG_BOOK_SCROLL_BUTTON, CONFIG_SCROLL_X + this.offsetX, 21 + this.offsetY, this.draggingConfigScroll);
    }

    private void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (mouseX >= this.offsetX && mouseY >= this.offsetY) {
            return;
        }
        for (GuiEventListener child : this.children()) {
            if (!(child instanceof TooltipProvider)) continue;
            TooltipProvider tooltipProvider = (TooltipProvider)child;
            if (!child.isMouseOver((double)mouseX, (double)mouseY)) continue;
            guiGraphics.renderComponentTooltip(FontRenderer.getInstance().getFont(), tooltipProvider.getTooltipLines(), mouseX, mouseY);
            break;
        }
    }

    private void importSettings(int clicked) {
        String clipboard = McUtils.mc().keyboardHandler.getClipboard();
        if (clicked == 0) {
            List<Configurable> configsToImport = Managers.Feature.getFeatures().stream().map(feature -> feature).collect(Collectors.toList());
            configsToImport.addAll(Managers.Overlay.getOverlays().stream().filter(overlay -> !configsToImport.contains(Managers.Overlay.getOverlayParent((Overlay)overlay))).toList());
            boolean imported = Managers.Config.importConfig(clipboard, configsToImport);
            if (imported) {
                McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.settingsScreen.importedAll").withStyle(ChatFormatting.GREEN));
            } else {
                McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.settingsScreen.import.failed").withStyle(ChatFormatting.RED));
            }
        } else if (clicked == 1) {
            if (this.selectedConfigurable != null) {
                boolean imported = Managers.Config.importConfig(clipboard, List.of(this.selectedConfigurable));
                if (imported) {
                    McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.settingsScreen.imported", (Object[])new Object[]{this.selectedConfigurable.getTranslatedName()}).withStyle(ChatFormatting.GREEN));
                } else {
                    McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.settingsScreen.import.failed").withStyle(ChatFormatting.RED));
                }
            } else {
                McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.settingsScreen.needToSelect").withStyle(ChatFormatting.RED));
            }
        }
        this.populateConfigurables();
    }

    private void exportSettings(int clicked) {
        String exportedSettings = "";
        if (clicked == 0) {
            List<Configurable> featuresToExport = Managers.Feature.getFeatures().stream().map(feature -> feature).collect(Collectors.toList());
            featuresToExport.addAll(Managers.Overlay.getOverlays().stream().filter(overlay -> !featuresToExport.contains(Managers.Overlay.getOverlayParent((Overlay)overlay))).toList());
            exportedSettings = Managers.Config.exportConfig(featuresToExport);
            McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.settingsScreen.exportedAll").withStyle(ChatFormatting.GREEN));
        } else if (clicked == 1) {
            if (this.selectedConfigurable != null) {
                exportedSettings = Managers.Config.exportConfig(List.of(this.selectedConfigurable));
                McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.settingsScreen.exported", (Object[])new Object[]{this.selectedConfigurable.getTranslatedName()}).withStyle(ChatFormatting.GREEN));
            } else {
                McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.settingsScreen.needToSelect").withStyle(ChatFormatting.RED));
            }
        }
        McUtils.mc().keyboardHandler.setClipboard(exportedSettings);
    }
}

