/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.settings.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public abstract class GeneralSettingsButton
extends WynntilsButton {
    protected static final CustomColor BACKGROUND_COLOR = new CustomColor(98, 34, 8);
    private static final CustomColor HOVER_BACKGROUND_COLOR = new CustomColor(158, 52, 16);
    private final int maskTopY;
    private final int maskBottomY;
    private final List<Component> tooltip;

    protected GeneralSettingsButton(int x, int y, int width, int height, Component title, List<Component> tooltip, int maskTopY, int maskBottomY) {
        super(x, y, width, height, title);
        this.tooltip = tooltip;
        this.maskTopY = maskTopY;
        this.maskBottomY = maskBottomY;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawRoundedRectWithBorder(poseStack, CommonColors.BLACK, this.getBackgroundColor(), this.getX(), this.getY(), 0.0f, this.width, this.height, 1.0f, 3, 3);
        FontRenderer.getInstance().renderScrollingAlignedTextInBox(poseStack, StyledText.fromComponent(this.getMessage()), this.getX(), this.getX() + this.width, this.getY(), this.getY() + this.height, this.width - 2, this.getTextColor(), HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.OUTLINE);
        if (this.isHovered && (mouseY <= this.maskTopY || mouseY >= this.maskBottomY)) {
            this.isHovered = false;
        }
        if (this.isHovered) {
            McUtils.screen().setTooltipForNextRenderPass(Lists.transform(this.tooltip, Component::getVisualOrderText));
        }
    }

    protected CustomColor getBackgroundColor() {
        return this.isHovered ? HOVER_BACKGROUND_COLOR : BACKGROUND_COLOR;
    }

    protected CustomColor getTextColor() {
        return this.isHovered ? CommonColors.YELLOW : CommonColors.WHITE;
    }
}

