/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.skillpointloadouts.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.character.type.SavableSkillPointSet;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.screens.skillpointloadouts.SkillPointLoadoutsScreen;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.RenderedStringUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class LoadoutWidget
extends AbstractWidget {
    private final float dividedWidth;
    private final String name;
    private final SavableSkillPointSet loadout;
    private final SkillPointLoadoutsScreen parent;
    private final List<String> gearNames = new ArrayList<String>();

    public LoadoutWidget(int x, int y, int width, int height, float dividedWidth, String name, SavableSkillPointSet loadout, SkillPointLoadoutsScreen parent) {
        super(x, y, width, height, (Component)Component.literal((String)name));
        this.dividedWidth = dividedWidth;
        this.name = name;
        this.loadout = loadout;
        this.parent = parent;
        if (loadout.weapon() != null) {
            this.gearNames.add(loadout.weapon());
        }
        this.gearNames.addAll(loadout.armourNames());
        this.gearNames.addAll(loadout.accessoryNames());
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        if (this.isMouseOver(mouseX, mouseY)) {
            RenderUtils.drawRect(poseStack, CommonColors.GRAY.withAlpha(100), this.getX(), this.getY(), 0.0f, this.width, this.height);
        }
        if (this.parent.getSelectedLoadout() != null && this.parent.getSelectedLoadout().key().equals(this.name)) {
            RenderUtils.drawRectBorders(poseStack, CommonColors.WHITE, this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), 1.0f, 0.5f);
        }
        int nameYOffset = 2;
        if (this.loadout.isBuild()) {
            nameYOffset = 3;
            String text = RenderedStringUtils.getMaxFittingText(String.join((CharSequence)", ", this.gearNames), this.dividedWidth * 19.0f, FontRenderer.getInstance().getFont());
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(text), this.dividedWidth * 4.0f, (float)this.getY() + (float)this.getHeight() / 4.0f * 3.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 0.8f);
        }
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(this.name + " (" + this.loadout.getSkillPointsSum() + " - " + String.valueOf(this.loadout.getMinimumCombatLevel() > Models.CombatXp.getCombatLevel().current() ? ChatFormatting.RED : "") + I18n.get((String)"screens.wynntils.skillPointLoadouts.widgetLevelText", (Object[])new Object[]{this.loadout.getMinimumCombatLevel()}) + String.valueOf(ChatFormatting.WHITE) + ")"), this.dividedWidth * 4.0f, (float)this.getY() + (float)this.getHeight() / (float)nameYOffset, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        for (int i = 0; i < 5; ++i) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(String.valueOf(Skill.values()[i].getColorCode()) + this.loadout.getSkillPointsAsArray()[i]), this.dividedWidth * (float)(21 + i * 2), (float)this.getY() + (float)this.getHeight() / 2.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        }
    }

    public void onClick(double mouseX, double mouseY) {
        this.parent.setSelectedLoadout(Pair.of(this.name, this.loadout));
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

