/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.skillpointloadouts.widgets;

import com.wynntils.core.components.Models;
import com.wynntils.models.character.type.SavableSkillPointSet;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.skillpointloadouts.SkillPointLoadoutsScreen;
import com.wynntils.utils.type.Pair;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class SaveButton
extends WynntilsButton {
    private final Component originalMessage;
    private final SkillPointLoadoutsScreen parent;
    private final Consumer<String> saveFunction;
    private boolean buttonConfirm = false;

    public SaveButton(int x, int y, int width, int height, Component message, SkillPointLoadoutsScreen parent, Consumer<String> saveFunction) {
        super(x, y, width, height, message);
        this.active = false;
        this.originalMessage = message;
        this.parent = parent;
        this.saveFunction = saveFunction;
    }

    public void onPress() {
        String name = this.parent.saveNameInput.getTextBoxInput();
        if (Models.SkillPoint.hasLoadout(name) && !this.buttonConfirm) {
            this.parent.hasSaveNameConflict = true;
            this.buttonConfirm = true;
            this.setMessage((Component)Component.translatable((String)"screens.wynntils.skillPointLoadouts.confirm").withStyle(ChatFormatting.RED));
        } else {
            this.saveFunction.accept(name);
            this.parent.populateLoadouts();
            this.parent.setSelectedLoadout(new Pair<String, SavableSkillPointSet>(name, Models.SkillPoint.getLoadouts().get(name)));
            this.parent.saveNameInput.setTextBoxInput("");
            this.parent.resetSaveButtons();
        }
    }

    public void reset() {
        this.buttonConfirm = false;
        this.setMessage(this.originalMessage);
    }
}

